/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.junit;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.csdn.ServiceFramwork;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.exception.RenderFinish;
import net.csdn.common.settings.Settings;
import net.csdn.junit.IocTest;
import net.csdn.modules.http.HttpServer;
import net.csdn.modules.http.RestController;
import net.csdn.modules.http.RestRequest;
import net.csdn.modules.http.RestResponse;
import net.csdn.modules.http.support.HttpHolder;
import net.csdn.modules.mock.MockRestRequest;
import net.csdn.modules.mock.MockRestResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseControllerTest
extends IocTest {
    boolean disableMysql = ((Settings)injector.getInstance(Settings.class)).getAsBoolean((Object)((Object)ServiceFramwork.mode) + ".datasources.mysql.disable", Boolean.valueOf(false));

    public RestResponse runAction(String path, Map params, RestRequest.Method method) throws Exception {
        MockRestResponse response = new MockRestResponse();
        HashMap<String, String> newParams = new HashMap<String, String>();
        for (Object key : params.keySet()) {
            newParams.put((String)key, params.get(key).toString());
        }
        RestController controller = (RestController)injector.getInstance(RestController.class);
        try {
            MockRestRequest restRequest = new MockRestRequest(path, newParams, method, null);
            HttpServer.setHttpHolder(new HttpHolder(restRequest, response));
            controller.dispatchRequest(restRequest, response);
        }
        catch (Exception e) {
            this.catchRenderFinish(e);
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void catchRenderFinish(Exception e) throws Exception {
        if (e instanceof RenderFinish) {
            if (this.disableMysql) return;
            this.commitTransaction();
            return;
        } else {
            if (!(e instanceof InvocationTargetException)) throw e;
            if (!(((InvocationTargetException)e).getTargetException() instanceof RenderFinish)) throw e;
            if (this.disableMysql) return;
            this.commitTransaction();
        }
    }

    public RestResponse runAction(String path, String rawParamsStr, RestRequest.Method method) throws Exception {
        MockRestResponse response = new MockRestResponse();
        RestController controller = (RestController)injector.getInstance(RestController.class);
        try {
            controller.dispatchRequest(new MockRestRequest(path, WowCollections.map((Object[])new Object[0]), method, rawParamsStr), response);
        }
        catch (Exception e) {
            this.catchRenderFinish(e);
        }
        return response;
    }

    public Map<RestRequest.Method, RestResponse> each(List<RestRequest.Method> methods, String path, Map params) throws Exception {
        Map maps = WowCollections.map((Object[])new Object[0]);
        for (RestRequest.Method method : methods) {
            maps.put(method, this.runAction(path, params, method));
        }
        return maps;
    }

    public Map<RestRequest.Method, RestResponse> each(List<RestRequest.Method> methods, String path, String rawParamStr) throws Exception {
        Map maps = WowCollections.map((Object[])new Object[0]);
        for (RestRequest.Method method : methods) {
            maps.put(method, this.runAction(path, rawParamStr, method));
        }
        return maps;
    }

    public RestResponse get(String path, Map params) throws Exception {
        return this.runAction(path, params, RestRequest.Method.GET);
    }

    public RestResponse post(String path, Map params) throws Exception {
        return this.runAction(path, params, RestRequest.Method.POST);
    }

    public RestResponse delete(String path, Map params) throws Exception {
        return this.runAction(path, params, RestRequest.Method.DELETE);
    }

    public RestResponse put(String path, Map params) throws Exception {
        return this.runAction(path, params, RestRequest.Method.PUT);
    }

    public RestResponse get(String path, String rawParamsStr) throws Exception {
        return this.runAction(path, rawParamsStr, RestRequest.Method.GET);
    }

    public RestResponse post(String path, String rawParamsStr) throws Exception {
        return this.runAction(path, rawParamsStr, RestRequest.Method.POST);
    }

    public RestResponse delete(String path, String rawParamsStr) throws Exception {
        return this.runAction(path, rawParamsStr, RestRequest.Method.DELETE);
    }

    public RestResponse put(String path, String rawParamsStr) throws Exception {
        return this.runAction(path, rawParamsStr, RestRequest.Method.PUT);
    }
}

