/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.bootstrap.loader.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javassist.CtClass;
import net.csdn.ServiceFramwork;
import net.csdn.annotation.AnnotationException;
import net.csdn.annotation.Service;
import net.csdn.bootstrap.loader.Loader;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.common.scan.ScanService;
import net.csdn.common.settings.Settings;

public class ServiceLoader
implements Loader {
    public void load(Settings settings) throws Exception {
        final ArrayList<Module> moduleList = new ArrayList<Module>();
        ServiceFramwork.scanService.scanArchives(settings.get("application.service"), new ScanService.LoadClassEnhanceCallBack(){

            public Class loaded(DataInputStream classFile) {
                try {
                    CtClass ctClass = ServiceFramwork.classPool.makeClass((InputStream)classFile);
                    if (!ctClass.hasAnnotation(Service.class)) {
                        return null;
                    }
                    final Class clzz = ctClass.toClass();
                    final Service service = clzz.getAnnotation(Service.class);
                    if (clzz.isInterface() && service.implementedBy() == null) {
                        throw new AnnotationException(MessageFormat.format((String)"{} no implemented class configured", (Object[])new Object[]{clzz.getName()}));
                    }
                    moduleList.add(new AbstractModule(){

                        protected void configure() {
                            if (clzz.isInterface()) {
                                this.bind(clzz).to(service.implementedBy()).in(service.value());
                            } else {
                                this.bind(clzz).in(service.value());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        moduleList.addAll(ServiceFramwork.serviceModules);
        ServiceFramwork.AllModules.addAll(moduleList);
    }
}

