/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.bootstrap.loader.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.io.DataInputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javassist.CtClass;
import net.csdn.ServiceFramwork;
import net.csdn.annotation.rest.At;
import net.csdn.annotation.rest.ErrorAction;
import net.csdn.annotation.rest.NoAction;
import net.csdn.bootstrap.loader.Loader;
import net.csdn.common.collect.Tuple;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.scan.ScanService;
import net.csdn.common.settings.Settings;
import net.csdn.enhancer.ControllerEnhancer;
import net.csdn.filter.FilterEnhancer;
import net.csdn.modules.http.ApplicationController;
import net.csdn.modules.http.RestController;
import net.csdn.modules.http.RestRequest;

public class ControllerLoader
implements Loader {
    private static final CSLogger logger = Loggers.getLogger(ControllerLoader.class);

    public void load(Settings settings) throws Exception {
        ServiceFramwork.injector = Guice.createInjector((Stage)Stage.PRODUCTION, ServiceFramwork.AllModules);
        ArrayList<Module> moduleList = new ArrayList<Module>();
        final List controllers = WowCollections.list((Object[])new Object[0]);
        final FilterEnhancer enhancer = new FilterEnhancer(settings);
        ServiceFramwork.scanService.scanArchives(settings.get("application.controller"), new ScanService.LoadClassEnhanceCallBack(){

            public Class loaded(DataInputStream classFile) {
                try {
                    CtClass ctClass = enhancer.enhanceThisClass(classFile);
                    controllers.add(ctClass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        ((ControllerEnhancer)enhancer).enhanceThisClass2(controllers);
        for (CtClass ctClass : controllers) {
            if (Modifier.isAbstract(ctClass.getModifiers())) continue;
            moduleList.add(ControllerLoader.bindAction(Class.forName(ctClass.getName())));
        }
        ServiceFramwork.injector = ServiceFramwork.injector.createChildInjector(moduleList);
    }

    private static Module bindAction(final Class clzz) {
        return new AbstractModule(){

            protected void configure() {
                if (clzz == null) {
                    return;
                }
                try {
                    Method[] methods;
                    boolean isController = false;
                    Class wow = clzz;
                    while (wow.getSuperclass() != null) {
                        if (wow.getSuperclass() == ApplicationController.class) {
                            isController = true;
                            break;
                        }
                        wow = wow.getSuperclass();
                    }
                    if (!isController) {
                        return;
                    }
                    for (Method method : methods = clzz.getDeclaredMethods()) {
                        RestRequest.Method[] httpMethods;
                        At at;
                        ErrorAction errorAction;
                        if (method.getModifiers() == 2) continue;
                        RestController restController = (RestController)ServiceFramwork.injector.getInstance(RestController.class);
                        NoAction noAction = method.getAnnotation(NoAction.class);
                        if (noAction != null) {
                            restController.setDefaultHandlerKey((Tuple<Class<ApplicationController>, Method>)new Tuple((Object)clzz, (Object)method));
                        }
                        if ((errorAction = method.getAnnotation(ErrorAction.class)) != null) {
                            restController.setErrorHandlerKey((Tuple<Class<ApplicationController>, Method>)new Tuple((Object)clzz, (Object)method));
                        }
                        if ((at = method.getAnnotation(At.class)) == null) continue;
                        String url = at.path()[0];
                        for (RestRequest.Method httpMethod : httpMethods = at.types()) {
                            Tuple tuple = new Tuple((Object)clzz, (Object)method);
                            restController.registerHandler(httpMethod, url, (Tuple<Class<ApplicationController>, Method>)tuple);
                        }
                        this.bind(clzz);
                    }
                }
                catch (Exception e) {
                    logger.error("System initialize error", (Throwable)e, new Object[0]);
                }
            }
        };
    }
}

