/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.bootstrap;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Stage;
import java.util.ArrayList;
import net.csdn.ServiceFramwork;
import net.csdn.bootstrap.loader.Loader;
import net.csdn.bootstrap.loader.impl.ControllerLoader;
import net.csdn.bootstrap.loader.impl.LoggerLoader;
import net.csdn.bootstrap.loader.impl.ModuelLoader;
import net.csdn.bootstrap.loader.impl.ServiceLoader;
import net.csdn.bootstrap.loader.impl.TemplateLoader;
import net.csdn.bootstrap.loader.impl.ThriftLoader;
import net.csdn.bootstrap.loader.impl.UtilLoader;
import net.csdn.common.collect.Tuple;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.scan.DefaultScanService;
import net.csdn.common.settings.ImmutableSettings;
import net.csdn.common.settings.InternalSettingsPreparer;
import net.csdn.common.settings.Settings;
import net.csdn.jpa.JPA;
import net.csdn.modules.http.HttpServer;
import net.csdn.modules.thrift.ThriftServer;
import net.csdn.mongo.MongoMongo;

public class Bootstrap {
    private static HttpServer httpServer;
    private static ThriftServer thriftServer;
    private static boolean isSystemConfigured;

    public static void main(String[] args) {
        try {
            Bootstrap.configureSystem();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(3);
        }
    }

    public static void shutdown() {
        if (httpServer != null) {
            httpServer.close();
        }
        if (thriftServer != null) {
            thriftServer.stop();
        }
    }

    private static void configureSystem() throws Exception {
        if (isSystemConfigured) {
            return;
        }
        Tuple tuple = InternalSettingsPreparer.prepareSettings((Settings)ImmutableSettings.Builder.EMPTY_SETTINGS);
        if (ServiceFramwork.mode.equals((Object)ServiceFramwork.Mode.development)) {
            ServiceFramwork.mode = ServiceFramwork.Mode.valueOf(((Settings)tuple.v1()).get("mode"));
        }
        Settings settings = (Settings)tuple.v1();
        boolean disableMysql = settings.getAsBoolean((Object)((Object)ServiceFramwork.mode) + ".datasources.mysql.disable", Boolean.valueOf(false));
        boolean disableMongo = settings.getAsBoolean((Object)((Object)ServiceFramwork.mode) + ".datasources.mongodb.disable", Boolean.valueOf(false));
        boolean disableHttp = settings.getAsBoolean("http.disable", Boolean.valueOf(false));
        boolean disableThrift = settings.getAsBoolean("thrift.disable", Boolean.valueOf(false));
        LoggerLoader loggerLoader = new LoggerLoader();
        loggerLoader.load(settings);
        if (ServiceFramwork.scanService.getLoader() == null || ServiceFramwork.scanService.getLoader() == DefaultScanService.class) {
            ServiceFramwork.scanService.setLoader(ServiceFramwork.class);
        }
        if (!disableMysql) {
            JPA.configure((JPA.CSDNORMConfiguration)new JPA.CSDNORMConfiguration(ServiceFramwork.mode.name(), (Settings)tuple.v1(), ServiceFramwork.scanService.getLoader(), ServiceFramwork.classPool));
        }
        if (!disableMongo) {
            MongoMongo.configure((MongoMongo.CSDNMongoConfiguration)new MongoMongo.CSDNMongoConfiguration(ServiceFramwork.mode.name(), (Settings)tuple.v1(), ServiceFramwork.scanService.getLoader(), ServiceFramwork.classPool));
        }
        ModuelLoader moduleLoader = new ModuelLoader();
        moduleLoader.load(settings);
        ArrayList<Loader> loaders = new ArrayList<Loader>();
        loaders.add(new ServiceLoader());
        loaders.add(new UtilLoader());
        loaders.add(new ControllerLoader());
        loaders.add(new TemplateLoader());
        if (!ServiceFramwork.mode.equals((Object)ServiceFramwork.Mode.test)) {
            loaders.add(new ThriftLoader());
        }
        for (Loader loader : loaders) {
            loader.load((Settings)tuple.v1());
        }
        if (WowCollections.isNull((Object)ServiceFramwork.injector)) {
            ServiceFramwork.injector = Guice.createInjector((Stage)Stage.PRODUCTION, ServiceFramwork.AllModules);
        }
        if (!disableMysql) {
            JPA.injector((Injector)ServiceFramwork.injector);
        }
        if (!disableMongo) {
            MongoMongo.injector((Injector)ServiceFramwork.injector);
        }
        isSystemConfigured = true;
        if (!disableThrift && !ServiceFramwork.mode.equals((Object)ServiceFramwork.Mode.test)) {
            thriftServer = (ThriftServer)ServiceFramwork.injector.getInstance(ThriftServer.class);
            thriftServer.start();
        }
        if (!disableHttp && !ServiceFramwork.mode.equals((Object)ServiceFramwork.Mode.test)) {
            httpServer = (HttpServer)ServiceFramwork.injector.getInstance(HttpServer.class);
            httpServer.start();
        }
        if (!(disableHttp && disableThrift || ServiceFramwork.mode.equals((Object)ServiceFramwork.Mode.test))) {
            Thread.currentThread().join();
        }
    }

    static {
        isSystemConfigured = false;
    }
}

