/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.mongo.enhancer;

import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.List;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.common.settings.Settings;
import net.csdn.mongo.MongoMongo;
import net.csdn.mongo.annotations.Transient;
import net.csdn.mongo.annotations.Validate;
import net.csdn.mongo.enhancer.Enhancer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoEnhancer
extends Enhancer {
    private Settings settings;
    private CSLogger logger = Loggers.getLogger(MongoEnhancer.class);
    private List<String> shouldNotCopyToSubclassStaticMethods = WowCollections.list((Object[])new String[]{"where", "select", "order", "skip", "limit", "count", "in", "not", "notIn", "create", "create9", "findById", "find", "findAll"});

    public MongoEnhancer(Settings settings) {
        this.settings = settings;
    }

    @Override
    public CtClass enhanceThisClass(DataInputStream dataInputStream) throws Exception {
        CtClass ctClass = this.classPool.makeClassIfNew((InputStream)dataInputStream);
        if (!ctClass.subtypeOf(this.classPool.get("net.csdn.mongo.Document"))) {
            return ctClass;
        }
        CtClass document = ctClass.getSuperclass();
        this.copyStaticFieldsToSubclass(document, ctClass);
        this.copyStaticMethodsToSubclass(document, ctClass);
        this.enhanceCriteriaClassMethods(ctClass);
        this.enhanceGetterSetterMethods(ctClass);
        this.enhanceAssociationMethods(ctClass);
        this.enhanceAssociationEmbedded(ctClass);
        return ctClass;
    }

    private void copyStaticFieldsToSubclass(CtClass document, CtClass targetClass) throws Exception {
        CtField[] ctFields;
        for (CtField ctField : ctFields = document.getFields()) {
            if (!Modifier.isStatic(ctField.getModifiers()) || !ctField.getName().startsWith("parent$_")) continue;
            CtField ctField1 = new CtField(ctField.getType(), ctField.getName(), targetClass);
            ctField1.setModifiers(ctField.getModifiers());
            targetClass.addField(ctField1);
        }
    }

    private void copyStaticMethodsToSubclass(CtClass document, CtClass targetClass) throws Exception {
        CtMethod[] ctMethods;
        for (CtMethod ctMethod : ctMethods = document.getMethods()) {
            if (!Modifier.isStatic(ctMethod.getModifiers()) || this.shouldNotCopyToSubclassStaticMethods.contains(ctMethod.getName())) continue;
            CtMethod ctNewMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)targetClass, null);
            targetClass.addMethod(ctNewMethod);
        }
    }

    private boolean isFinal(CtField ctField) {
        return Modifier.isFinal(ctField.getModifiers());
    }

    private boolean isStatic(CtField ctField) {
        return Modifier.isStatic(ctField.getModifiers());
    }

    private void enhanceGetterSetterMethods(CtClass ctClass) throws Exception {
        for (CtField ctField : ctClass.getDeclaredFields()) {
            if (this.isFinal(ctField) || this.isStatic(ctField) || ctField.hasAnnotation(Validate.class) || ctField.hasAnnotation(Transient.class) || ctField.getName().contains("$")) continue;
            String originalPropertyName = ctField.getName();
            String propertyName = ctField.getName().substring(0, 1).toUpperCase() + ctField.getName().substring(1);
            String getter = "get" + propertyName;
            String setter = "set" + propertyName;
            try {
                CtMethod ctMethod = ctClass.getDeclaredMethod(getter);
                if (ctMethod.getParameterTypes().length > 0 || Modifier.isStatic(ctMethod.getModifiers())) {
                    throw new NotFoundException("it's not a getter !");
                }
            }
            catch (NotFoundException noGetter) {
                String code = "public " + ctField.getType().getName() + " " + getter + "() { return this." + ctField.getName() + "; }";
                CtMethod getMethod = CtMethod.make((String)code, (CtClass)ctClass);
                getMethod.setModifiers(getMethod.getModifiers() | 0x1000);
                ctClass.addMethod(getMethod);
            }
            String methodBody = MessageFormat.format((String)"attributes.put({},{});", (Object[])new Object[]{"translateFromAlias(\"" + originalPropertyName + "\")", "value"});
            try {
                CtMethod ctMethod = ctClass.getDeclaredMethod(setter);
                if (ctMethod.getParameterTypes().length != 1 || !ctMethod.getParameterTypes()[0].equals(ctField.getType()) || Modifier.isStatic(ctMethod.getModifiers())) {
                    throw new NotFoundException("it's not a setter !");
                }
                ctClass.getClassFile().getMethods().remove(ctClass.getClassFile().getMethod(ctMethod.getName()));
            }
            catch (NotFoundException noSetter) {
                // empty catch block
            }
            CtMethod setMethod = CtMethod.make((String)("public void " + setter + "(" + ctField.getType().getName() + " value) { " + methodBody + " this." + ctField.getName() + " = value; }"), (CtClass)ctClass);
            setMethod.setModifiers(setMethod.getModifiers() | 0x1000);
            ctClass.addMethod(setMethod);
        }
    }

    private void enhanceAssociationEmbedded(CtClass ctClass) throws Exception {
        CtMethod[] modelMethods;
        for (CtMethod ctMethod : modelMethods = ctClass.getMethods()) {
            String returnType = ctMethod.getReturnType().getName();
            if (Modifier.isStatic(ctMethod.getModifiers()) || !"net.csdn.mongo.embedded.AssociationEmbedded".equals(returnType)) continue;
            String name = ctMethod.getName();
            ctMethod.setBody("return ((net.csdn.mongo.embedded.AssociationEmbedded)associationsEmbeddedMetaData().get(\"" + name + "\")).doNotUseMePlease_newMe(this);");
        }
    }

    private void enhanceAssociationMethods(CtClass ctClass) throws Exception {
        CtMethod[] modelMethods;
        for (CtMethod ctMethod : modelMethods = ctClass.getMethods()) {
            String returnType = ctMethod.getReturnType().getName();
            if (Modifier.isStatic(ctMethod.getModifiers()) || !"net.csdn.mongo.association.Association".equals(returnType)) continue;
            String name = ctMethod.getName();
            ctMethod.setBody("return ((net.csdn.mongo.association.Association)associationsMetaData().get(\"" + name + "\")).doNotUseMePlease_newMe(this);");
        }
    }

    private void enhanceCriteriaClassMethods(CtClass ctClass) throws Exception {
        String entityName = ctClass.getName();
        CtMethod findAll = CtMethod.make((String)("public static java.util.List findAll() {        return new net.csdn.mongo.Criteria(" + entityName + ".class).findAll();" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(findAll);
        CtMethod create = CtMethod.make((String)("public static net.csdn.mongo.Document create(java.util.Map params) { " + entityName + " doc = new " + entityName + "();" + "doc.attributes.putAll(translateKeyForParams(params));" + "doc.copyAllAttributesToPojoFields();" + "return doc;}"), (CtClass)ctClass);
        ctClass.addMethod(create);
        CtMethod create9 = CtMethod.make((String)("public static net.csdn.mongo.Document create9(java.util.Map params) { " + entityName + " doc = new " + entityName + "();" + "doc.attributes=translateKeyForParams(params);" + "doc.copyAllAttributesToPojoFields();" + "return doc;}"), (CtClass)ctClass);
        ctClass.addMethod(create9);
        String newCriteriaPiece = "new net.csdn.mongo.Criteria(" + entityName + ".class)";
        String returnTypeCriteriaPiece = "net.csdn.mongo.Criteria";
        CtMethod where = CtMethod.make((String)MessageFormat.format((String)"public static {} {}(java.util.Map params) {        return {}.{}(params);}", (Object[])new Object[]{returnTypeCriteriaPiece, "where", newCriteriaPiece, "where"}), (CtClass)ctClass);
        ctClass.addMethod(where);
        CtMethod select = CtMethod.make((String)("public static net.csdn.mongo.Criteria select(java.util.List params) {        return new net.csdn.mongo.Criteria(" + entityName + ".class).select(" + "params" + ");" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(select);
        CtMethod order = CtMethod.make((String)("public static net.csdn.mongo.Criteria order(java.util.Map params) {        return new net.csdn.mongo.Criteria(" + entityName + ".class).order(" + "params" + ");" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(order);
        CtMethod skip = CtMethod.make((String)("public static net.csdn.mongo.Criteria skip(int params) {        return new net.csdn.mongo.Criteria(" + entityName + ".class).skip(" + "params" + ");" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(skip);
        CtMethod limit = CtMethod.make((String)("public static net.csdn.mongo.Criteria limit(int params) {        return new net.csdn.mongo.Criteria(" + entityName + ".class).limit(" + "params" + ");" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(limit);
        CtMethod count = CtMethod.make((String)("public static int count() {        return new net.csdn.mongo.Criteria(" + entityName + ".class).count(" + ");" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(count);
        CtMethod in = CtMethod.make((String)("public static net.csdn.mongo.Criteria in(java.util.Map params) {        return new net.csdn.mongo.Criteria(" + entityName + ".class).in(" + "params" + ");" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(in);
        CtMethod not = CtMethod.make((String)("public static net.csdn.mongo.Criteria not(java.util.Map params) {        return new net.csdn.mongo.Criteria(" + entityName + ".class).not(" + "params" + ");" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(not);
        CtMethod notIn = CtMethod.make((String)("public static net.csdn.mongo.Criteria notIn(java.util.Map params) {        return new net.csdn.mongo.Criteria(" + entityName + ".class).notIn(" + "params" + ");" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(notIn);
        CtMethod findById = CtMethod.make((String)("public static Object findById(Object params) {        return new net.csdn.mongo.Criteria(" + entityName + ".class).findById(" + "params" + ");" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(findById);
        CtMethod findMulti = CtMethod.make((String)("public static java.util.List find(java.util.List params) {        return new net.csdn.mongo.Criteria(" + entityName + ".class).find(" + "params" + ");" + "    }"), (CtClass)ctClass);
        ctClass.addMethod(findMulti);
    }

    @Override
    public void enhanceThisClass2(List<CtClass> ctClasses) throws Exception {
        for (CtClass ctClass : ctClasses) {
            this.logger.info(MongoMongo.getMongoConfiguration().getClassLoader().getClassLoader() + " load " + ctClass.getName(), new Object[0]);
            ctClass.toClass(MongoMongo.getMongoConfiguration().getClassLoader().getClassLoader(), MongoMongo.getMongoConfiguration().getClassLoader().getProtectionDomain());
        }
    }
}

