/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.validate.impl;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.csdn.common.collections.WowCollections;
import net.csdn.jpa.model.JPQL;
import net.csdn.validate.BaseValidateParse;
import net.csdn.validate.ValidateHelper;
import net.csdn.validate.ValidateParse;
import net.csdn.validate.ValidateResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uniqueness
extends BaseValidateParse {
    private static String notice = "{} is not uniq";

    @Override
    public void parse(final Object target, final List<ValidateResult> validateResultList) {
        try {
            final Class<?> clzz = target.getClass();
            this.iterateValidateInfo(clzz, ValidateHelper.uniqueness, new ValidateParse.ValidateIterator(){

                public void iterate(String targetFieldName, Field field, Object info) throws Exception {
                    String msg = notice;
                    if (info instanceof Map) {
                        msg = Uniqueness.this.messageWithDefault((Map)info, notice);
                    }
                    Field tempField = clzz.getDeclaredField(targetFieldName);
                    tempField.setAccessible(true);
                    Object value = tempField.get(target);
                    String whereCondition = targetFieldName + "=:hold";
                    List models = ((JPQL)clzz.getDeclaredMethod("where", String.class, Map.class).invoke(null, whereCondition, WowCollections.map((Object[])new Object[]{"hold", value}))).fetch();
                    if (models.size() > 0) {
                        validateResultList.add(Uniqueness.this.validateResult(msg, targetFieldName));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

