/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.validate.impl;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.csdn.validate.BaseValidateParse;
import net.csdn.validate.ValidateHelper;
import net.csdn.validate.ValidateParse;
import net.csdn.validate.ValidateResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Numericality
extends BaseValidateParse {
    private static String notice = "{} is not a valid numeric";

    @Override
    public void parse(final Object target, final List<ValidateResult> validateResultList) {
        final Class<?> clzz = target.getClass();
        this.iterateValidateInfo(clzz, ValidateHelper.numericality, new ValidateParse.ValidateIterator(){

            public void iterate(String targetFieldName, Field field, Object info) throws Exception {
                String msg = notice;
                if (info instanceof Map) {
                    msg = Numericality.this.messageWithDefault((Map)info, notice);
                }
                Map numInfo = (Map)info;
                Comparable value = (Comparable)Numericality.this.getModelField(clzz, targetFieldName).get(target);
                for (String key : numInfo.keySet()) {
                    if (key.equals(ValidateHelper.Numericality.odd) || key.equals(ValidateHelper.Numericality.even)) {
                        if (Numericality.this.oddOrEven(key, value)) continue;
                        validateResultList.add(Numericality.this.validateResult(msg, targetFieldName));
                        continue;
                    }
                    Comparable double2 = (Comparable)numInfo.get(key);
                    if (Numericality.this.numericCompare(key, value, double2)) continue;
                    validateResultList.add(Numericality.this.validateResult(msg, targetFieldName));
                }
            }
        });
    }

    private boolean oddOrEven(String method, Comparable value) {
        try {
            return (Boolean)ValidateHelper.Numericality.class.getDeclaredMethod(method, Integer.class).invoke(null, (Integer)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean numericCompare(String method, Comparable d1, Comparable d2) {
        try {
            return (Boolean)ValidateHelper.Numericality.class.getDeclaredMethod(method, Comparable.class, Comparable.class).invoke(null, d1, d2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

