/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.persist.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.settings.Settings;
import net.csdn.modules.persist.mysql.DataSourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlClient {
    private DataSource dataSource = null;
    private static Map<String, MysqlClient> mysqlManagers = new HashMap<String, MysqlClient>();
    private DataSourceManager dataSourceManager;
    private CSLogger logger = Loggers.getLogger(MysqlClient.class);
    private Settings settings;

    public MysqlClient settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public MysqlClient(DataSourceManager _dataSourceManager, Settings _settings) {
        this.settings = _settings;
        for (Map.Entry<String, DataSource> entry : _dataSourceManager.dataSourceMap().entrySet()) {
            mysqlManagers.put(entry.getKey(), new MysqlClient(_dataSourceManager, this.settings, entry.getValue()));
        }
    }

    public MysqlClient(DataSourceManager _dataSourceManager) {
        for (Map.Entry<String, DataSource> entry : _dataSourceManager.dataSourceMap().entrySet()) {
            mysqlManagers.put(entry.getKey(), new MysqlClient(_dataSourceManager, null, entry.getValue()));
        }
    }

    public MysqlClient(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private MysqlClient(DataSourceManager dataSourceManager, Settings settings, DataSource _dataSource) {
        this.settings = settings;
        this.dataSource = _dataSource;
        this.dataSourceManager = dataSourceManager;
    }

    public MysqlClient mysqlService(String dataSourceName) {
        return mysqlManagers.get(dataSourceName);
    }

    public MysqlClient defaultMysqlService() {
        return mysqlManagers.get("mysql");
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    private Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql, Object ... params) {
        Connection conn = null;
        Statement preparedStatement = null;
        try {
            conn = this.getConnection();
            preparedStatement = this.preparedStatement(conn, sql, false);
            if (params.length > 0) {
                MysqlClient.setParams((PreparedStatement)preparedStatement, params);
            }
            preparedStatement.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    private PreparedStatement preparedStatement(Connection conn, String sql, boolean streaming) throws Exception {
        if (streaming) {
            PreparedStatement preparedStatement = conn.prepareStatement(sql, 1003, 1007);
            preparedStatement.setFetchSize(1000);
        }
        return conn.prepareStatement(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStreaming(String sql, Object ... params) {
        Connection conn = null;
        Statement preparedStatement = null;
        try {
            conn = this.getConnection();
            preparedStatement = this.preparedStatement(conn, sql, true);
            if (params.length > 0) {
                MysqlClient.setParams((PreparedStatement)preparedStatement, params);
            }
            preparedStatement.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public <T> Set<T> projectionByColumn(String sql, final String columnName, Object ... objs) {
        return (Set)this.defaultMysqlService().executeQuery(sql, new SqlCallback(){

            public Object execute(ResultSet rs) {
                HashSet<Object> temp = new HashSet<Object>();
                try {
                    while (rs.next()) {
                        temp.add(rs.getObject(columnName));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return temp;
            }
        }, objs);
    }

    public <T> List<T> projectionByColumn2(String sql, final String columnName, Object ... objs) {
        return (List)this.defaultMysqlService().executeQuery(sql, new SqlCallback(){

            public Object execute(ResultSet rs) {
                ArrayList<Object> temp = new ArrayList<Object>();
                try {
                    while (rs.next()) {
                        temp.add(rs.getObject(columnName));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return temp;
            }
        }, objs);
    }

    public List<Map> query(String sql, Object ... objs) {
        return (List)this.defaultMysqlService().executeQuery(sql, new SqlCallback(){

            public Object execute(ResultSet rs) {
                return MysqlClient.rsToMaps(rs);
            }
        }, objs);
    }

    public List<Map> streamingQuery(String sql, Object ... objs) {
        return (List)this.defaultMysqlService().executeStreamingQuery(sql, new SqlCallback(){

            public Object execute(ResultSet rs) {
                return MysqlClient.rsToMaps(rs);
            }
        }, objs);
    }

    public Map single_query(String sql, Object ... objs) {
        return (Map)this.defaultMysqlService().executeQuery(sql, new SqlCallback(){

            public Object execute(ResultSet rs) {
                try {
                    return MysqlClient.rsToMapSingle(rs, MysqlClient.getRsCloumns(rs));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }, objs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void executeBatch(String sql, BatchSqlCallback callback) {
        block19: {
            Connection conn = null;
            PreparedStatement preparedStatement = null;
            long time1 = System.currentTimeMillis();
            conn = this.getConnection();
            preparedStatement = conn.prepareStatement(sql);
            callback.execute(preparedStatement);
            preparedStatement.executeBatch();
            Object var9_6 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
                this.logger.info(" Load (" + (System.currentTimeMillis() - time1) + "ms)", new Object[0]);
                this.logger.info(sql, new Object[0]);
            }
            break block19;
            {
                catch (SQLException e) {
                    e.printStackTrace();
                    Object var9_7 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
                        this.logger.info(" Load (" + (System.currentTimeMillis() - time1) + "ms)", new Object[0]);
                        this.logger.info(sql, new Object[0]);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
                    this.logger.info(" Load (" + (System.currentTimeMillis() - time1) + "ms)", new Object[0]);
                    this.logger.info(sql, new Object[0]);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map executeQuerySingle(String sql, Object ... params) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long time1 = System.currentTimeMillis();
        conn = this.getConnection();
        preparedStatement = conn.prepareStatement(sql);
        resultSet = preparedStatement.executeQuery();
        Map map = MysqlClient.rsToMapSingle(resultSet, MysqlClient.getRsCloumns(resultSet));
        Object var10_9 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        long time2 = System.currentTimeMillis();
        if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
            this.logger.info(" Load (" + (time2 - time1) + "ms)", new Object[0]);
            this.logger.info(sql, new Object[0]);
        }
        return map;
        catch (SQLException e) {
            try {
                e.printStackTrace();
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                time2 = System.currentTimeMillis();
                if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
                    this.logger.info(" Load (" + (time2 - time1) + "ms)", new Object[0]);
                    this.logger.info(sql, new Object[0]);
                }
                throw throwable;
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            time2 = System.currentTimeMillis();
            if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
                this.logger.info(" Load (" + (time2 - time1) + "ms)", new Object[0]);
                this.logger.info(sql, new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <T> T executeQuery(String sql, SqlCallback<T> callback, Object ... params) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long time1 = System.currentTimeMillis();
        conn = this.getConnection();
        preparedStatement = this.preparedStatement(conn, sql, false);
        if (params.length > 0) {
            MysqlClient.setParams(preparedStatement, params);
        }
        resultSet = preparedStatement.executeQuery();
        T t = callback.execute(resultSet);
        Object var11_10 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        long time2 = System.currentTimeMillis();
        if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
            this.logger.info(" Load (" + (time2 - time1) + "ms) " + sql + "  [" + WowCollections.join((Object[])params, (String)",") + "]", new Object[0]);
        }
        return t;
        catch (Exception e) {
            try {
                e.printStackTrace();
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                time2 = System.currentTimeMillis();
                if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
                    this.logger.info(" Load (" + (time2 - time1) + "ms) " + sql + "  [" + WowCollections.join((Object[])params, (String)",") + "]", new Object[0]);
                }
                throw throwable;
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            time2 = System.currentTimeMillis();
            if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
                this.logger.info(" Load (" + (time2 - time1) + "ms) " + sql + "  [" + WowCollections.join((Object[])params, (String)",") + "]", new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <T> T executeStreamingQuery(String sql, SqlCallback<T> callback, Object ... params) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long time1 = System.currentTimeMillis();
        conn = this.getConnection();
        preparedStatement = this.preparedStatement(conn, sql, true);
        if (params.length > 0) {
            MysqlClient.setParams(preparedStatement, params);
        }
        resultSet = preparedStatement.executeQuery();
        T t = callback.execute(resultSet);
        Object var11_10 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        long time2 = System.currentTimeMillis();
        if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
            this.logger.info(" Load (" + (time2 - time1) + "ms) " + sql + "  [" + WowCollections.join((Object[])params, (String)",") + "]", new Object[0]);
        }
        return t;
        catch (Exception e) {
            try {
                e.printStackTrace();
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                time2 = System.currentTimeMillis();
                if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
                    this.logger.info(" Load (" + (time2 - time1) + "ms) " + sql + "  [" + WowCollections.join((Object[])params, (String)",") + "]", new Object[0]);
                }
                throw throwable;
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            time2 = System.currentTimeMillis();
            if (this.settings.getAsBoolean("enable_sql_log", Boolean.valueOf(false)).booleanValue()) {
                this.logger.info(" Load (" + (time2 - time1) + "ms) " + sql + "  [" + WowCollections.join((Object[])params, (String)",") + "]", new Object[0]);
            }
        }
        return null;
    }

    public static Map rsToMapSingle(ResultSet rs, String[] keys) throws SQLException {
        try {
            boolean haveNext = rs.next();
            if (!haveNext) {
                return null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String[] _keys = keys;
        if (_keys == null) {
            _keys = MysqlClient.getRsCloumns(rs);
        }
        Map temp = MysqlClient.rsToMap(rs, _keys);
        return temp;
    }

    public static Map rsToMap(ResultSet rs, String[] keys) {
        HashMap<String, Object> temp = new HashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            try {
                temp.put(keys[i], rs.getObject(keys[i]));
                continue;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return temp;
    }

    public static List<Map> rsToMaps(ResultSet rs, String[] keys) {
        ArrayList<Map> result = new ArrayList<Map>();
        try {
            while (rs.next()) {
                result.add(MysqlClient.rsToMap(rs, keys));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<Map> rsToMaps(ResultSet rs) {
        ArrayList<Map> result = new ArrayList<Map>();
        try {
            while (rs.next()) {
                result.add(MysqlClient.rsToMap(rs, MysqlClient.getRsCloumns(rs)));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String[] getRsCloumns(ResultSet rs) throws SQLException {
        ResultSetMetaData rsm = rs.getMetaData();
        String[] columns = new String[rsm.getColumnCount()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = rsm.getColumnLabel(i + 1);
        }
        return columns;
    }

    private static void setParams(PreparedStatement ps, Object[] params) throws SQLException {
        if (params == null || params.length == 0) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            ps.setObject(i + 1, params[i]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SqlListCallback<T> {
        public List<T> execute(ResultSet var1);
    }

    public static interface BatchSqlCallback {
        public void execute(PreparedStatement var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SqlCallback<T> {
        public T execute(ResultSet var1);
    }
}

