/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.persist.mysql;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.csdn.common.settings.Settings;
import net.csdn.jpa.JPA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceManager {
    private Map<String, DataSource> dataSourceMap;
    private Settings settings;

    @Inject
    public DataSourceManager(Settings _settings) {
        this.settings = _settings;
        this.dataSourceMap = this.buildDataSourceMap();
    }

    public DataSource datasource(String name) {
        return this.dataSourceMap.get(name);
    }

    public Map<String, DataSource> dataSourceMap() {
        return this.dataSourceMap;
    }

    private Map<String, DataSource> buildDataSourceMap() {
        HashMap<String, DataSource> tempDataSourceMap = new HashMap<String, DataSource>();
        Map groups = this.settings.getGroups(JPA.mode() + ".datasources");
        for (Map.Entry group : groups.entrySet()) {
            if (!((String)group.getKey()).equals("mysql")) continue;
            tempDataSourceMap.put((String)group.getKey(), this.buildPool((Settings)group.getValue()));
        }
        return tempDataSourceMap;
    }

    private DataSource buildPool(Settings mysqlSetting) {
        try {
            DruidDataSource dataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource(JPA.properties());
            return dataSource;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("can not create datasource");
        }
    }
}

