/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.enhancer;

import java.util.List;
import java.util.Map;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import net.csdn.annotation.callback.AfterLoad;
import net.csdn.annotation.callback.AfterSave;
import net.csdn.annotation.callback.AfterUpdate;
import net.csdn.annotation.callback.BeforeDestroy;
import net.csdn.annotation.callback.BeforeSave;
import net.csdn.annotation.callback.BeforeUpdate;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.enhancer.EnhancerHelper;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.common.settings.Settings;
import net.csdn.enhancer.BitEnhancer;
import net.csdn.enhancer.association.ManyToManyEnhancer;
import net.csdn.enhancer.association.ManyToOneEnhancer;
import net.csdn.enhancer.association.OneToManyEnhancer;
import net.csdn.enhancer.association.OneToOneEnhancer;
import net.csdn.jpa.enhancer.ModelClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationEnhancer
implements BitEnhancer {
    private Settings settings;
    private Map<Class, Class> callback_classes = WowCollections.map((Object[])new Object[]{AfterSave.class, PostPersist.class, BeforeSave.class, PrePersist.class, BeforeUpdate.class, PreUpdate.class, AfterUpdate.class, PostUpdate.class, BeforeDestroy.class, PostRemove.class, AfterLoad.class, PostLoad.class});

    public AssociationEnhancer(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void enhance(List<ModelClass> modelClasses) throws Exception {
        for (ModelClass modelClass : modelClasses) {
            this.inner_enhance(modelClass);
        }
    }

    public void inner_enhance(ModelClass modelClass) throws Exception {
        CtClass ctClass = modelClass.originClass;
        this.enhanceJPACallback(ctClass);
        OneToOneEnhancer oneToOneEnhancer = new OneToOneEnhancer(modelClass);
        oneToOneEnhancer.enhancer();
        OneToManyEnhancer oneToManyEnhancer = new OneToManyEnhancer(modelClass);
        oneToManyEnhancer.enhancer();
        ManyToOneEnhancer manyToOneEnhancer = new ManyToOneEnhancer(modelClass);
        manyToOneEnhancer.enhancer();
        ManyToManyEnhancer manyToManyEnhancer = new ManyToManyEnhancer(modelClass);
        manyToManyEnhancer.enhancer();
        ctClass.defrost();
    }

    private void enhanceJPACallback(CtClass ctClass) throws Exception {
        CtMethod[] methods;
        for (CtMethod ctMethod : methods = ctClass.getDeclaredMethods()) {
            if (ctMethod.hasAnnotation(AfterSave.class)) {
                this.enhanceJPACallback(ctClass, ctMethod, AfterSave.class);
            }
            if (ctMethod.hasAnnotation(BeforeSave.class)) {
                this.enhanceJPACallback(ctClass, ctMethod, BeforeSave.class);
            }
            if (ctMethod.hasAnnotation(AfterUpdate.class)) {
                this.enhanceJPACallback(ctClass, ctMethod, AfterUpdate.class);
            }
            if (ctMethod.hasAnnotation(BeforeUpdate.class)) {
                this.enhanceJPACallback(ctClass, ctMethod, BeforeUpdate.class);
            }
            if (ctMethod.hasAnnotation(BeforeDestroy.class)) {
                this.enhanceJPACallback(ctClass, ctMethod, BeforeDestroy.class);
            }
            if (!ctMethod.hasAnnotation(AfterLoad.class)) continue;
            this.enhanceJPACallback(ctClass, ctMethod, AfterLoad.class);
        }
    }

    private void enhanceJPACallback(CtClass ctClass, CtMethod method, Class anno) throws Exception {
        if (method.hasAnnotation(anno)) {
            CtMethod ctMethod = CtMethod.make((String)MessageFormat.format((String)"public void {}() {\n        net.csdn.jpa.context.JPAContext jpaContext = getJPAConfig().reInitJPAContext();\n        try {\n            {}();\n            getJPAConfig().getJPAContext().closeTx(false);\n        } catch (Exception e) {\n            getJPAConfig().getJPAContext().closeTx(true);\n        } finally {\n            getJPAConfig().setJPAContext(jpaContext);\n        }\n    }", (Object[])new Object[]{"$_" + method.getName(), method.getName()}), (CtClass)ctClass);
            ctClass.addMethod(ctMethod);
            AnnotationsAttribute annotationsAttribute = EnhancerHelper.getAnnotations((CtMethod)ctMethod);
            EnhancerHelper.createAnnotation((AnnotationsAttribute)annotationsAttribute, (Class)this.callback_classes.get(anno));
        }
    }
}

