/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.context;

import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceException;
import net.csdn.jpa.context.JPAConfig;
import net.csdn.jpa.model.JPQL;

public class JPAContext {
    private JPAConfig jpaConfig;
    private EntityManager entityManager;

    protected JPAContext(JPAConfig jpaConfig) {
        this.jpaConfig = jpaConfig;
        EntityManager manager = jpaConfig.newEntityManager();
        manager.setFlushMode(FlushModeType.COMMIT);
        manager.getTransaction().begin();
        this.entityManager = manager;
    }

    public JPAConfig getJPAConfig() {
        return this.jpaConfig;
    }

    public JPQL jpql() {
        return new JPQL(this);
    }

    public JPQL jpql(String entity) {
        return new JPQL(this, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTx(boolean rollback) {
        try {
            if (this.entityManager.getTransaction().isActive()) {
                if (rollback || this.entityManager.getTransaction().getRollbackOnly()) {
                    this.entityManager.getTransaction().rollback();
                } else {
                    try {
                        this.entityManager.getTransaction().commit();
                    }
                    catch (Throwable e) {
                        for (int i = 0; i < 10; ++i) {
                            if (e instanceof PersistenceException && e.getCause() != null) {
                                e = e.getCause();
                                break;
                            }
                            if ((e = e.getCause()) == null) break;
                        }
                        throw new RuntimeException("Cannot commit", e);
                    }
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.entityManager.close();
            this.jpaConfig.clearJPAContext();
            throw throwable;
        }
        this.entityManager.close();
        this.jpaConfig.clearJPAContext();
    }

    protected void close() {
        this.entityManager.close();
    }

    public EntityManager em() {
        return this.entityManager;
    }

    public void setRollbackOnly() {
        this.entityManager.getTransaction().setRollbackOnly();
    }

    public int execute(String query) {
        return this.entityManager.createQuery(query).executeUpdate();
    }

    public boolean isInsideTransaction() {
        return this.entityManager.getTransaction() != null;
    }
}

