/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa;

import com.google.inject.Injector;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import net.csdn.common.collect.Tuple;
import net.csdn.common.env.Environment;
import net.csdn.common.io.Streams;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.common.scan.DefaultScanService;
import net.csdn.common.scan.ScanService;
import net.csdn.common.settings.Settings;
import net.csdn.enhancer.ActiveORMEnhancer;
import net.csdn.jpa.context.JPAConfig;
import net.csdn.jpa.enhancer.JPAEnhancer;
import net.csdn.jpa.enhancer.ModelClass;
import net.csdn.jpa.model.Model;
import net.csdn.jpa.type.DBInfo;
import net.csdn.jpa.type.DBType;
import net.csdn.jpa.type.impl.MysqlType;
import net.csdn.validate.ValidatorLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPA {
    private static CSLogger logger = Loggers.getLogger(JPA.class);
    private static JPAConfig jpaConfig;
    public static final Map<String, Class<Model>> models;
    private static CSDNORMConfiguration ormConfiguration;

    public static void configure(CSDNORMConfiguration csdnormConfiguration) {
        ormConfiguration = csdnormConfiguration;
        ormConfiguration.buildDefaultDBInfo();
        JPA.loadModels();
        try {
            new ValidatorLoader().load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized JPAConfig getJPAConfig() {
        if (jpaConfig == null) {
            try {
                JPA.modifyPersistenceXml((Tuple<Settings, Environment>)new Tuple((Object)JPA.settings(), (Object)JPA.environment()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            jpaConfig = new JPAConfig(JPA.properties(), JPA.settings().get(JPA.mode() + ".datasources.mysql.database"));
        }
        return jpaConfig;
    }

    private static void modifyPersistenceXml(Tuple<Settings, Environment> tuple) throws Exception {
        File persistFile;
        String fileContent = JPA.persistenceContent();
        Map groups = ((Settings)tuple.v1()).getGroups(JPA.mode() + ".datasources");
        Settings mysqlSetting = (Settings)groups.get("mysql");
        StringBuffer stringBuffer = new StringBuffer();
        for (Class<Model> clzz : models.values()) {
            stringBuffer.append(MessageFormat.format((String)"<class>{}</class>", (Object[])new Object[]{clzz.getName()}));
        }
        String path = JPA.classLoader().getResource(".").getPath();
        File persistDir = new File(path + "META-INF/");
        if (!persistDir.exists()) {
            persistDir.mkdirs();
        }
        if ((persistFile = new File(persistDir.getPath() + "/persistence.xml")).exists()) {
            persistFile.delete();
        }
        Streams.copy((String)MessageFormat.format((String)fileContent, (Object[])new Object[]{mysqlSetting.get("database"), stringBuffer.toString()}), (Writer)new FileWriter(persistFile));
    }

    private static String persistenceContent() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<persistence xmlns=\"http://java.sun.com/xml/ns/persistence\"\n             xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n             xsi:schemaLocation=\"http://java.sun.com/xml/ns/persistence http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd\"\n             version=\"2.0\">\n    <persistence-unit name=\"{}\">\n        {}\n        <properties>\n        </properties>\n    </persistence-unit>\n</persistence>";
    }

    public static void setJPAConfig(JPAConfig _jpaConfig) {
        jpaConfig = _jpaConfig;
    }

    public static ClassLoader classLoader() {
        return ormConfiguration.classLoader.getClassLoader();
    }

    public static String mode() {
        return ormConfiguration.mode;
    }

    public static ClassPool classPool() {
        return ormConfiguration.classPool;
    }

    public static Injector injector() {
        return ormConfiguration.injector;
    }

    public static Settings settings() {
        return ormConfiguration.settings;
    }

    public static Environment environment() {
        return ormConfiguration.environment;
    }

    public static DBType dbType() {
        return ormConfiguration.dbType;
    }

    public static DBInfo dbInfo() {
        return ormConfiguration.dbInfo;
    }

    public static Map<String, String> properties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        Map groups = JPA.settings().getGroups(JPA.mode() + ".datasources");
        Settings mysqlSetting = (Settings)groups.get("mysql");
        properties.put("hibernate.connection.provider_class", mysqlSetting.get("provider_class", "net.csdn.hibernate.support.DruidConnectionProvider"));
        properties.put("show_sql", mysqlSetting.get("show_sql", "true"));
        properties.put("driver_class", mysqlSetting.get("driver", "com.mysql.jdbc.Driver"));
        properties.put("dialect", "org.hibernate.dialect.MySQLDialect");
        properties.put("format_sql", mysqlSetting.get("format_sql", "false"));
        properties.put("url", "jdbc:mysql://" + mysqlSetting.get("host") + "/" + mysqlSetting.get("database") + "?useUnicode=true&characterEncoding=utf8");
        properties.put("username", mysqlSetting.get("username"));
        properties.put("password", mysqlSetting.get("password"));
        properties.put("maxActive", mysqlSetting.get("maxActive", "50"));
        properties.put("minIdle", mysqlSetting.get("minIdle", "3"));
        properties.put("initialSize", mysqlSetting.get("initialSize", "30"));
        properties.put("maxWait", mysqlSetting.get("maxWait", "20"));
        properties.put("testOnBorrow", mysqlSetting.get("testOnBorrow", "false"));
        properties.put("validationQuery", mysqlSetting.get("validationQuery", "SELECT 1"));
        properties.put("validationQueryTimeout", mysqlSetting.get("validationQueryTimeout", "60000"));
        properties.put("removeAbandoned", mysqlSetting.get("removeAbandoned", "false"));
        properties.put("removeAbandonedTimeout", mysqlSetting.get("removeAbandonedTimeout", "1800"));
        properties.put("logAbandoned", mysqlSetting.get("logAbandoned", "false"));
        properties.put("init", mysqlSetting.get("init", "true"));
        properties.put("testWhileIdle", mysqlSetting.get("testWhileIdle", "true"));
        properties.put("connectionProperties", "druid.stat.logSlowSql=" + mysqlSetting.get("logSlowSql", "true") + ";druid.stat.slowSqlMillis=" + mysqlSetting.get("slowSqlMillis", "500"));
        properties.put("filters", "log4j");
        return properties;
    }

    public static void loadModels() {
        try {
            new JPAModelLoader().load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void injector(Injector injector) {
        ormConfiguration.injector = injector;
    }

    static {
        models = new HashMap<String, Class<Model>>();
    }

    public static class JPAModelLoader {
        public void load() throws Exception {
            final JPAEnhancer enhancer = new JPAEnhancer(JPA.settings());
            final ArrayList<CtClass> classList = new ArrayList<CtClass>();
            DefaultScanService scanService = new DefaultScanService();
            scanService.setLoader(ormConfiguration.classLoader);
            scanService.scanArchives(JPA.settings().get("application.model"), new ScanService.LoadClassEnhanceCallBack(){

                public Class loaded(DataInputStream classFile) {
                    try {
                        CtClass clzz = enhancer.enhanceThisClass(classFile);
                        if (clzz != null) {
                            classList.add(clzz);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
            List<ModelClass> roots = ((ActiveORMEnhancer)enhancer).enhanceThisClass2(classList);
            for (ModelClass modelClass : roots) {
                this.loadClass(modelClass);
            }
        }

        private void loadClass(ModelClass modelClass) {
            this.loadClass(modelClass.originClass);
            for (ModelClass temp : modelClass.children()) {
                if (temp.isLeafNode()) {
                    this.loadClass(temp.originClass);
                    continue;
                }
                this.loadClass(temp);
            }
        }

        private void loadClass(CtClass ctClass) {
            try {
                Class clzz = ctClass.toClass(JPA.classLoader(), JPA.class.getProtectionDomain());
                models.put(clzz.getSimpleName(), clzz);
            }
            catch (CannotCompileException e) {
                e.printStackTrace();
            }
        }
    }

    public static class CSDNORMConfiguration {
        private Settings settings;
        private Environment environment;
        private Class classLoader;
        private String mode;
        private ClassPool classPool;
        private Injector injector;
        private DBType dbType;
        private DBInfo dbInfo;

        public Settings getSettings() {
            return this.settings;
        }

        public void setSettings(Settings settings) {
            this.settings = settings;
        }

        public Environment getEnvironment() {
            return this.environment;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader.getClassLoader();
        }

        public void setClassLoader(Class classLoader) {
            this.classLoader = classLoader;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public ClassPool getClassPool() {
            return this.classPool;
        }

        public void setClassPool(ClassPool classPool) {
            this.classPool = classPool;
        }

        public Injector getInjector() {
            return this.injector;
        }

        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public DBType getDbType() {
            return this.dbType;
        }

        public void setDbType(DBType dbType) {
            this.dbType = dbType;
        }

        public DBInfo getDbInfo() {
            return this.dbInfo;
        }

        public void setDbInfo(DBInfo dbInfo) {
            this.dbInfo = dbInfo;
        }

        public CSDNORMConfiguration(String _mode, Settings _settings, Class _classLoader) {
            this.mode = _mode;
            this.settings = _settings;
            this.classLoader = _classLoader;
            this.buildDefaultClassPool();
            this.buildDefaultDbType();
        }

        public CSDNORMConfiguration(String _mode, Settings _settings, Class _classLoader, ClassPool classPool) {
            this.mode = _mode;
            this.settings = _settings;
            this.classLoader = _classLoader;
            this.classPool = classPool;
            this.buildDefaultDbType();
        }

        public void buildDefaultClassPool() {
            this.classPool = new ClassPool();
            this.classPool.appendSystemPath();
            this.classPool.appendClassPath((ClassPath)new LoaderClassPath(this.classLoader.getClassLoader()));
        }

        public void buildDefaultDbType() {
            this.dbType = new MysqlType();
        }

        public void buildDefaultDBInfo() {
            this.dbInfo = new DBInfo(this.settings);
        }
    }
}

