/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

final class NegatingFilter
extends Filter {
    private static final long serialVersionUID = 3218934851787738661L;
    private final Filter filter;

    NegatingFilter(Filter filter) {
        this.filter = (Filter)Preconditions.checkNotNull((Object)filter, (Object)"The filter to negate must be provided");
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        int n = reader.maxDoc();
        FixedBitSet bits = new FixedBitSet(reader.maxDoc());
        DocIdSet set = this.filter.getDocIdSet(reader);
        if (set == null || set == DocIdSet.EMPTY_DOCIDSET) {
            bits.set(0, n);
        } else {
            DocIdSetIterator i = set.iterator();
            if (i == null) {
                bits.set(0, n);
            } else {
                bits.or(i);
                bits.flip(0, n);
            }
        }
        return bits;
    }
}

