/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import java.util.HashSet;
import javax.annotation.Nullable;

final class ExplicitComparator<T>
implements Comparator<T> {
    private final ImmutableMap<T, Integer> rankMap;
    private final int otherRank;

    static <T> ExplicitComparator<T> of(Iterable<? extends T> values) {
        return new ExplicitComparator<T>(values);
    }

    private ExplicitComparator(Iterable<? extends T> values) {
        Preconditions.checkNotNull(values);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet visited = Sets.newHashSet();
        int rank = 0;
        for (Object value : Iterables.filter(values, (Predicate)Predicates.notNull())) {
            if (!visited.add(value)) continue;
            builder.put(value, (Object)rank);
            ++rank;
        }
        this.rankMap = builder.build();
        this.otherRank = rank + 1;
    }

    private int rank(@Nullable T value) {
        Integer rank = (Integer)this.rankMap.get(value);
        if (rank != null) {
            return rank;
        }
        return this.otherRank;
    }

    @Override
    public int compare(T o1, T o2) {
        return Ints.compare((int)this.rank(o1), (int)this.rank(o2));
    }
}

