/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.document;

import javax.annotation.Nullable;
import net.conquiris.lucene.document.FieldBuilder;
import net.conquiris.schema.SchemaItem;
import org.apache.lucene.document.Field;

public abstract class IndexableFieldBuilder<B extends IndexableFieldBuilder<B>>
extends FieldBuilder<B> {
    private boolean store = false;
    private boolean index = true;

    IndexableFieldBuilder(String name) {
        super(name);
    }

    IndexableFieldBuilder(SchemaItem item) {
        super(item);
        this.index = item.isIndexed();
        this.store = item.isStored();
    }

    public final boolean isStored() {
        return this.store;
    }

    public final boolean isIndexed() {
        return this.index;
    }

    public final B store(boolean store) {
        this.store = store;
        return (B)((Object)((IndexableFieldBuilder)this.thisValue()));
    }

    public final B store() {
        return this.store(true);
    }

    public final B store(@Nullable Field.Store store) {
        return this.store(Field.Store.YES == store);
    }

    public final B index(boolean index) {
        this.index = index;
        return (B)((Object)((IndexableFieldBuilder)this.thisValue()));
    }
}

