/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.conquiris.lucene.search.DoubleComparatorSource;
import net.conquiris.lucene.search.ExplicitComparator;
import net.conquiris.lucene.search.FloatComparatorSource;
import net.conquiris.lucene.search.IntComparatorSource;
import net.conquiris.lucene.search.LongComparatorSource;
import net.conquiris.lucene.search.SearchSupport;
import net.conquiris.schema.BooleanSchemaItem;
import net.conquiris.schema.DoubleSchemaItem;
import net.conquiris.schema.FloatSchemaItem;
import net.conquiris.schema.InstantSchemaItem;
import net.conquiris.schema.IntegerSchemaItem;
import net.conquiris.schema.LongSchemaItem;
import net.conquiris.schema.SchemaItem;
import net.conquiris.schema.TextSchemaItem;
import net.derquinse.common.base.Builder;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public final class SortBuilder
implements Builder<Sort> {
    private final List<SortField> fields = Lists.newLinkedList();

    private SortBuilder() {
    }

    private static String checkSortable(SchemaItem item) {
        String name = SearchSupport.checkItem(item);
        Preconditions.checkArgument((boolean)item.isIndexed(), (String)"The provided field [%s] is not indexed", (Object[])new Object[]{name});
        return name;
    }

    public static SortBuilder newBuilder() {
        return new SortBuilder();
    }

    public static SortField field(TextSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 3, reverse);
    }

    public static SortField field(TextSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(IntegerSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 4, reverse);
    }

    public static SortField field(IntegerSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(LongSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 6, reverse);
    }

    public static SortField field(LongSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(FloatSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 5, reverse);
    }

    public static SortField field(FloatSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(DoubleSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 7, reverse);
    }

    public static SortField field(DoubleSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(BooleanSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 4, reverse);
    }

    public static SortField field(BooleanSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(InstantSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 6, reverse);
    }

    public static SortField field(InstantSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(IntegerSchemaItem field, Comparator<Integer> comparator, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), (FieldComparatorSource)new IntComparatorSource(comparator), reverse);
    }

    public static SortField field(IntegerSchemaItem field, Comparator<Integer> comparator) {
        return SortBuilder.field(field, comparator, false);
    }

    public static SortField field(IntegerSchemaItem field, Iterable<Integer> values, boolean reverse) {
        return SortBuilder.field(field, ExplicitComparator.of(values), false);
    }

    public static SortField field(IntegerSchemaItem field, Iterable<Integer> values) {
        return SortBuilder.field(field, values, false);
    }

    public static SortField field(IntegerSchemaItem field, int ... values) {
        return SortBuilder.field(field, Ints.asList((int[])values));
    }

    public static SortField field(LongSchemaItem field, Comparator<Long> comparator, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), (FieldComparatorSource)new LongComparatorSource(comparator), reverse);
    }

    public static SortField field(LongSchemaItem field, Comparator<Long> comparator) {
        return SortBuilder.field(field, comparator, false);
    }

    public static SortField field(LongSchemaItem field, Iterable<Long> values, boolean reverse) {
        return SortBuilder.field(field, ExplicitComparator.of(values), false);
    }

    public static SortField field(LongSchemaItem field, Iterable<Long> values) {
        return SortBuilder.field(field, values, false);
    }

    public static SortField field(LongSchemaItem field, long ... values) {
        return SortBuilder.field(field, Longs.asList((long[])values));
    }

    public static SortField field(FloatSchemaItem field, Comparator<Float> comparator, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), (FieldComparatorSource)new FloatComparatorSource(comparator), reverse);
    }

    public static SortField field(FloatSchemaItem field, Comparator<Float> comparator) {
        return SortBuilder.field(field, comparator, false);
    }

    public static SortField field(FloatSchemaItem field, Iterable<Float> values, boolean reverse) {
        return SortBuilder.field(field, ExplicitComparator.of(values), false);
    }

    public static SortField field(FloatSchemaItem field, Iterable<Float> values) {
        return SortBuilder.field(field, values, false);
    }

    public static SortField field(FloatSchemaItem field, float ... values) {
        return SortBuilder.field(field, Floats.asList((float[])values));
    }

    public static SortField field(DoubleSchemaItem field, Comparator<Double> comparator, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), (FieldComparatorSource)new DoubleComparatorSource(comparator), reverse);
    }

    public static SortField field(DoubleSchemaItem field, Comparator<Double> comparator) {
        return SortBuilder.field(field, comparator, false);
    }

    public static SortField field(DoubleSchemaItem field, Iterable<Double> values, boolean reverse) {
        return SortBuilder.field(field, ExplicitComparator.of(values), false);
    }

    public static SortField field(DoubleSchemaItem field, Iterable<Double> values) {
        return SortBuilder.field(field, values, false);
    }

    public static SortField field(DoubleSchemaItem field, double ... values) {
        return SortBuilder.field(field, Doubles.asList((double[])values));
    }

    public Sort build() {
        if (this.fields.isEmpty()) {
            return new Sort();
        }
        SortField[] array = new SortField[this.fields.size()];
        this.fields.toArray(array);
        return new Sort(array);
    }

    public SortBuilder add(SortField field) {
        this.fields.add((SortField)Preconditions.checkNotNull((Object)field));
        return this;
    }

    public SortBuilder add(Iterable<? extends SortField> fields) {
        for (SortField sortField : fields) {
            this.add(sortField);
        }
        return this;
    }

    public SortBuilder add(SortField ... fields) {
        return this.add(Arrays.asList(fields));
    }

    public SortBuilder add(TextSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(TextSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(IntegerSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(IntegerSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(LongSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(LongSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(FloatSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(FloatSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(DoubleSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(DoubleSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(BooleanSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(BooleanSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(InstantSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(InstantSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(IntegerSchemaItem field, Comparator<Integer> comparator, boolean reverse) {
        return this.add(SortBuilder.field(field, comparator, reverse));
    }

    public SortBuilder add(IntegerSchemaItem field, Comparator<Integer> comparator) {
        return this.add(SortBuilder.field(field, comparator));
    }

    public SortBuilder add(IntegerSchemaItem field, Iterable<Integer> values, boolean reverse) {
        return this.add(SortBuilder.field(field, values, reverse));
    }

    public SortBuilder add(IntegerSchemaItem field, Iterable<Integer> values) {
        return this.add(SortBuilder.field(field, values));
    }

    public SortBuilder add(IntegerSchemaItem field, int ... values) {
        return this.add(SortBuilder.field(field, values));
    }

    public SortBuilder add(LongSchemaItem field, Comparator<Long> comparator, boolean reverse) {
        return this.add(SortBuilder.field(field, comparator, reverse));
    }

    public SortBuilder add(LongSchemaItem field, Comparator<Long> comparator) {
        return this.add(SortBuilder.field(field, comparator));
    }

    public SortBuilder add(LongSchemaItem field, Iterable<Long> values, boolean reverse) {
        return this.add(SortBuilder.field(field, values, reverse));
    }

    public SortBuilder add(LongSchemaItem field, Iterable<Long> values) {
        return this.add(SortBuilder.field(field, values));
    }

    public SortBuilder add(LongSchemaItem field, long ... values) {
        return this.add(SortBuilder.field(field, values));
    }

    public SortBuilder add(FloatSchemaItem field, Comparator<Float> comparator, boolean reverse) {
        return this.add(SortBuilder.field(field, comparator, reverse));
    }

    public SortBuilder add(FloatSchemaItem field, Comparator<Float> comparator) {
        return this.add(SortBuilder.field(field, comparator));
    }

    public SortBuilder add(FloatSchemaItem field, Iterable<Float> values, boolean reverse) {
        return this.add(SortBuilder.field(field, values, reverse));
    }

    public SortBuilder add(FloatSchemaItem field, Iterable<Float> values) {
        return this.add(SortBuilder.field(field, values));
    }

    public SortBuilder add(FloatSchemaItem field, float ... values) {
        return this.add(SortBuilder.field(field, values));
    }

    public SortBuilder add(DoubleSchemaItem field, Comparator<Double> comparator, boolean reverse) {
        return this.add(SortBuilder.field(field, comparator, reverse));
    }

    public SortBuilder add(DoubleSchemaItem field, Comparator<Double> comparator) {
        return this.add(SortBuilder.field(field, comparator));
    }

    public SortBuilder add(DoubleSchemaItem field, Iterable<Double> values, boolean reverse) {
        return this.add(SortBuilder.field(field, values, reverse));
    }

    public SortBuilder add(DoubleSchemaItem field, Iterable<Double> values) {
        return this.add(SortBuilder.field(field, values));
    }

    public SortBuilder add(DoubleSchemaItem field, double ... values) {
        return this.add(SortBuilder.field(field, values));
    }
}

