/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.text.Collator;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.conquiris.lucene.index.Terms;
import net.conquiris.lucene.search.SearchSupport;
import net.conquiris.schema.BooleanSchemaItem;
import net.conquiris.schema.DoubleSchemaItem;
import net.conquiris.schema.FloatSchemaItem;
import net.conquiris.schema.InstantSchemaItem;
import net.conquiris.schema.IntegerSchemaItem;
import net.conquiris.schema.LongSchemaItem;
import net.conquiris.schema.SchemaItem;
import net.conquiris.schema.TextSchemaItem;
import net.conquiris.schema.UUIDSchemaItem;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.joda.time.ReadableInstant;

public final class Queries
extends SearchSupport {
    private Queries() {
    }

    public static TermQuery termQuery(Term term) {
        return new TermQuery(Queries.checkTerm(term));
    }

    public static Function<Term, TermQuery> termQueryBuilder() {
        return TermQueryBuilder.INSTANCE;
    }

    public static TermQuery termQuery(String field, String value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(String field, int value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(String field, long value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(String field, float value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(String field, double value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(String field, boolean value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(String field, UUID value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(String field, ReadableInstant value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(TextSchemaItem field, String value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(IntegerSchemaItem field, int value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(LongSchemaItem field, long value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(FloatSchemaItem field, float value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(DoubleSchemaItem field, double value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(BooleanSchemaItem field, boolean value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(UUIDSchemaItem field, UUID value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static TermQuery termQuery(InstantSchemaItem field, ReadableInstant value) {
        return Queries.termQuery(Terms.term(field, value));
    }

    public static Query termRange(String field, @Nullable String lowerTerm, @Nullable String upperTerm, boolean includeLower, boolean includeUpper, Collator collator) {
        Queries.checkField(field);
        if (lowerTerm == null && upperTerm == null) {
            return new MatchAllDocsQuery();
        }
        return new TermRangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, collator);
    }

    public static Query termRange(String field, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return Queries.termRange(field, lowerTerm, upperTerm, includeLower, includeUpper, null);
    }

    public static Query termRange(TextSchemaItem field, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, Collator collator) {
        return Queries.termRange(Queries.checkItem((SchemaItem)field), lowerTerm, upperTerm, includeLower, includeUpper, collator);
    }

    public static Query termRange(TextSchemaItem field, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return Queries.termRange(Queries.checkItem((SchemaItem)field), lowerTerm, upperTerm, includeLower, includeUpper);
    }

    public static Query termRange(String field, Range<String> range, Collator collator) {
        Queries.checkField(field);
        Queries.checkRange(range);
        return Queries.termRange(field, Queries.min(range), Queries.max(range), Queries.minIncluded(range), Queries.maxIncluded(range), collator);
    }

    public static Query termRange(String field, Range<String> range) {
        Queries.checkField(field);
        Queries.checkRange(range);
        return Queries.termRange(field, Queries.min(range), Queries.max(range), Queries.minIncluded(range), Queries.maxIncluded(range));
    }

    public static Query termRange(TextSchemaItem field, Range<String> range, Collator collator) {
        return Queries.termRange(Queries.checkItem((SchemaItem)field), range, collator);
    }

    public static Query termRange(TextSchemaItem field, Range<String> range) {
        return Queries.termRange(Queries.checkItem((SchemaItem)field), range);
    }

    public static Query intRange(String field, @Nullable Integer min, @Nullable Integer max, boolean minInclusive, boolean maxInclusive) {
        Queries.checkField(field);
        if (min == null && max == null) {
            return new MatchAllDocsQuery();
        }
        return NumericRangeQuery.newIntRange((String)field, (Integer)min, (Integer)max, (boolean)minInclusive, (boolean)maxInclusive);
    }

    public static Query intRange(IntegerSchemaItem field, @Nullable Integer min, @Nullable Integer max, boolean minInclusive, boolean maxInclusive) {
        return Queries.intRange(Queries.checkItem((SchemaItem)field), min, max, minInclusive, maxInclusive);
    }

    public static Query intRange(String field, Range<Integer> range) {
        Queries.checkField(field);
        Queries.checkRange(range);
        return Queries.intRange(field, Queries.min(range), Queries.max(range), Queries.minIncluded(range), Queries.maxIncluded(range));
    }

    public static Query intRange(IntegerSchemaItem field, Range<Integer> range) {
        return Queries.intRange(Queries.checkItem((SchemaItem)field), range);
    }

    public static Query longRange(String field, @Nullable Long min, @Nullable Long max, boolean minInclusive, boolean maxInclusive) {
        Queries.checkField(field);
        if (min == null && max == null) {
            return new MatchAllDocsQuery();
        }
        return NumericRangeQuery.newLongRange((String)field, (Long)min, (Long)max, (boolean)minInclusive, (boolean)maxInclusive);
    }

    public static Query longRange(LongSchemaItem field, @Nullable Long min, @Nullable Long max, boolean minInclusive, boolean maxInclusive) {
        return Queries.longRange(Queries.checkItem((SchemaItem)field), min, max, minInclusive, maxInclusive);
    }

    public static Query longRange(String field, Range<Long> range) {
        Queries.checkField(field);
        Queries.checkRange(range);
        return Queries.longRange(field, Queries.min(range), Queries.max(range), Queries.minIncluded(range), Queries.maxIncluded(range));
    }

    public static Query longRange(LongSchemaItem field, Range<Long> range) {
        return Queries.longRange(Queries.checkItem((SchemaItem)field), range);
    }

    public static Query floatRange(String field, @Nullable Float min, @Nullable Float max, boolean minInclusive, boolean maxInclusive) {
        Queries.checkField(field);
        if (min == null && max == null) {
            return new MatchAllDocsQuery();
        }
        return NumericRangeQuery.newFloatRange((String)field, (Float)min, (Float)max, (boolean)minInclusive, (boolean)maxInclusive);
    }

    public static Query floatRange(FloatSchemaItem field, @Nullable Float min, @Nullable Float max, boolean minInclusive, boolean maxInclusive) {
        return Queries.floatRange(Queries.checkItem((SchemaItem)field), min, max, minInclusive, maxInclusive);
    }

    public static Query floatRange(String field, Range<Float> range) {
        Queries.checkField(field);
        Queries.checkRange(range);
        return Queries.floatRange(field, Queries.min(range), Queries.max(range), Queries.minIncluded(range), Queries.maxIncluded(range));
    }

    public static Query floatRange(FloatSchemaItem field, Range<Float> range) {
        return Queries.floatRange(Queries.checkItem((SchemaItem)field), range);
    }

    public static Query doubleRange(String field, @Nullable Double min, @Nullable Double max, boolean minInclusive, boolean maxInclusive) {
        Queries.checkField(field);
        if (min == null && max == null) {
            return new MatchAllDocsQuery();
        }
        return NumericRangeQuery.newDoubleRange((String)field, (Double)min, (Double)max, (boolean)minInclusive, (boolean)maxInclusive);
    }

    public static Query doubleRange(DoubleSchemaItem field, @Nullable Double min, @Nullable Double max, boolean minInclusive, boolean maxInclusive) {
        return Queries.doubleRange(Queries.checkItem((SchemaItem)field), min, max, minInclusive, maxInclusive);
    }

    public static Query doubleRange(String field, Range<Double> range) {
        Queries.checkField(field);
        Queries.checkRange(range);
        return Queries.doubleRange(field, Queries.min(range), Queries.max(range), Queries.minIncluded(range), Queries.maxIncluded(range));
    }

    public static Query doubleRange(DoubleSchemaItem field, Range<Double> range) {
        return Queries.doubleRange(Queries.checkItem((SchemaItem)field), range);
    }

    public static Query instantRange(String field, @Nullable ReadableInstant min, @Nullable ReadableInstant max, boolean minInclusive, boolean maxInclusive) {
        Queries.checkField(field);
        if (min == null && max == null) {
            return new MatchAllDocsQuery();
        }
        return NumericRangeQuery.newLongRange((String)field, (Long)(min != null ? Long.valueOf(min.getMillis()) : null), (Long)(max != null ? Long.valueOf(max.getMillis()) : null), (boolean)minInclusive, (boolean)maxInclusive);
    }

    public static Query instantRange(InstantSchemaItem field, @Nullable ReadableInstant min, @Nullable ReadableInstant max, boolean minInclusive, boolean maxInclusive) {
        return Queries.instantRange(Queries.checkItem((SchemaItem)field), min, max, minInclusive, maxInclusive);
    }

    public static Query instantRange(String field, Range<? extends ReadableInstant> range) {
        Queries.checkField(field);
        Queries.checkRange(range);
        return Queries.instantRange(field, Queries.min(range), Queries.max(range), Queries.minIncluded(range), Queries.maxIncluded(range));
    }

    public static Query instantRange(InstantSchemaItem field, Range<? extends ReadableInstant> range) {
        return Queries.instantRange(Queries.checkItem((SchemaItem)field), range);
    }

    public static BooleanQuery addClauses(BooleanQuery query, BooleanClause.Occur occur, Iterable<? extends Query> queries) {
        Preconditions.checkNotNull((Object)query, (Object)"The destination boolean query must be provided");
        Preconditions.checkNotNull((Object)occur, (Object)"The occurrence specification must be provided");
        ImmutableList list = ImmutableList.copyOf(queries);
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"At least one query must be provided");
        for (Query query2 : queries) {
            query.add(query2, occur);
        }
        return query;
    }

    public static BooleanQuery addClauses(BooleanQuery query, BooleanClause.Occur occur, Query ... queries) {
        return Queries.addClauses(query, occur, Arrays.asList(queries));
    }

    public static BooleanQuery addTermClauses(BooleanQuery query, BooleanClause.Occur occur, Iterable<? extends Term> terms) {
        return Queries.addClauses(query, occur, Iterables.transform(terms, Queries.termQueryBuilder()));
    }

    public static BooleanQuery addTermClauses(BooleanQuery query, BooleanClause.Occur occur, Term ... terms) {
        return Queries.addTermClauses(query, occur, Arrays.asList(terms));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, Iterable<? extends Query> queries) {
        return Queries.addClauses(new BooleanQuery(), occur, queries);
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, Query ... queries) {
        return Queries.addClauses(new BooleanQuery(), occur, queries);
    }

    public static BooleanQuery booleanTermQuery(BooleanClause.Occur occur, Iterable<? extends Term> terms) {
        return Queries.addTermClauses(new BooleanQuery(), occur, terms);
    }

    public static BooleanQuery booleanTermQuery(BooleanClause.Occur occur, Term ... terms) {
        return Queries.addTermClauses(new BooleanQuery(), occur, Arrays.asList(terms));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, TextSchemaItem field, Iterable<String> values) {
        return Queries.booleanTermQuery(occur, Iterables.transform(values, Terms.termBuilder(field)));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, TextSchemaItem field, String ... values) {
        return Queries.booleanQuery(occur, field, Arrays.asList(values));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, IntegerSchemaItem field, Iterable<Integer> values) {
        return Queries.booleanTermQuery(occur, Iterables.transform(values, Terms.termBuilder(field)));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, IntegerSchemaItem field, int ... values) {
        return Queries.booleanQuery(occur, field, Ints.asList((int[])values));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, LongSchemaItem field, Iterable<Long> values) {
        return Queries.booleanTermQuery(occur, Iterables.transform(values, Terms.termBuilder(field)));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, LongSchemaItem field, long ... values) {
        return Queries.booleanQuery(occur, field, Longs.asList((long[])values));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, FloatSchemaItem field, Iterable<Float> values) {
        return Queries.booleanTermQuery(occur, Iterables.transform(values, Terms.termBuilder(field)));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, FloatSchemaItem field, float ... values) {
        return Queries.booleanQuery(occur, field, Floats.asList((float[])values));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, DoubleSchemaItem field, Iterable<Double> values) {
        return Queries.booleanTermQuery(occur, Iterables.transform(values, Terms.termBuilder(field)));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, DoubleSchemaItem field, double ... values) {
        return Queries.booleanQuery(occur, field, Doubles.asList((double[])values));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, BooleanSchemaItem field, Iterable<Boolean> values) {
        return Queries.booleanTermQuery(occur, Iterables.transform(values, Terms.termBuilder(field)));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, BooleanSchemaItem field, boolean ... values) {
        return Queries.booleanQuery(occur, field, Booleans.asList((boolean[])values));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, InstantSchemaItem field, Iterable<? extends ReadableInstant> values) {
        return Queries.booleanTermQuery(occur, Iterables.transform(values, Terms.termBuilder(field)));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, InstantSchemaItem field, ReadableInstant ... values) {
        return Queries.booleanQuery(occur, field, Arrays.asList(values));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, UUIDSchemaItem field, Iterable<UUID> values) {
        return Queries.booleanTermQuery(occur, Iterables.transform(values, Terms.termBuilder(field)));
    }

    public static BooleanQuery booleanQuery(BooleanClause.Occur occur, UUIDSchemaItem field, UUID ... values) {
        return Queries.booleanQuery(occur, field, Arrays.asList(values));
    }

    private static enum TermQueryBuilder implements Function<Term, TermQuery>
    {
        INSTANCE;


        public TermQuery apply(Term input) {
            return Queries.termQuery(input);
        }
    }
}

