/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import java.io.IOException;
import java.util.Comparator;
import net.conquiris.lucene.search.GenericComparatorSource;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.Bits;

final class IntComparatorSource
extends GenericComparatorSource<Integer> {
    private static final long serialVersionUID = 6482544719528657501L;

    IntComparatorSource(Comparator<Integer> comparator) {
        super(comparator);
    }

    public FieldComparator<Integer> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        return new IntComparator(fieldname, reversed, numHits);
    }

    final class IntComparator
    extends GenericComparatorSource.GenericComparator {
        IntComparator(String field, boolean reverse, int numHits) {
            super(Integer.class, field, reverse, numHits);
        }

        Integer[] load(IndexReader reader, int docBase) throws IOException {
            int[] p = FieldCache.DEFAULT.getInts(reader, this.getField(), FieldCache.NUMERIC_UTILS_INT_PARSER, true);
            Bits docsWithField = FieldCache.DEFAULT.getDocsWithField(reader, this.getField());
            if (docsWithField instanceof Bits.MatchAllBits) {
                docsWithField = null;
            }
            int n = p.length;
            Integer[] values = new Integer[n];
            for (int i = 0; i < n; ++i) {
                int v = p[i];
                values[i] = docsWithField != null && v == 0 && !docsWithField.get(i) ? null : Integer.valueOf(v);
            }
            return values;
        }
    }
}

