/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.conquiris.lucene.search.FieldValues;
import net.conquiris.schema.AbstractWithFieldNameProperty;
import net.conquiris.schema.BinarySchemaItem;
import net.conquiris.schema.BooleanSchemaItem;
import net.conquiris.schema.ByteStringSchemaItem;
import net.conquiris.schema.DoubleSchemaItem;
import net.conquiris.schema.FloatSchemaItem;
import net.conquiris.schema.InstantSchemaItem;
import net.conquiris.schema.IntegerSchemaItem;
import net.conquiris.schema.LongSchemaItem;
import net.conquiris.schema.SchemaItem;
import net.conquiris.schema.TextSchemaItem;
import net.conquiris.schema.UUIDSchemaItem;
import net.derquinse.common.base.ByteString;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.joda.time.Instant;

public final class Hit
implements Supplier<Document> {
    private final int docId;
    private final float score;
    private final Document document;
    private final ImmutableMultimap<String, String> fragments;
    private final ImmutableListMultimap<String, Fieldable> fields;
    private final ImmutableListMultimap<String, Number> numeric;
    private final ImmutableListMultimap<String, Fieldable> binary;

    public static Hit of(int docId, float score, Document document, @Nullable Multimap<String, String> fragments) {
        return new Hit(docId, score, document, fragments);
    }

    private Hit(int docId, float score, Document document, @Nullable Multimap<String, String> fragments) {
        this.docId = docId;
        this.score = score;
        this.document = (Document)Preconditions.checkNotNull((Object)document, (Object)"The document must be provided");
        this.fragments = fragments == null ? ImmutableMultimap.of() : ImmutableMultimap.copyOf(fragments);
        ImmutableListMultimap.Builder fieldsBuilder = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder numericBuilder = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder binaryBuilder = ImmutableListMultimap.builder();
        for (Fieldable f : document.getFields()) {
            String name = f.name();
            if (f.isBinary()) {
                binaryBuilder.put((Object)name, (Object)f);
                continue;
            }
            fieldsBuilder.put((Object)name, (Object)f);
            if (!(f instanceof NumericField)) continue;
            numericBuilder.put((Object)name, (Object)((NumericField)f).getNumericValue());
        }
        this.fields = fieldsBuilder.build();
        this.numeric = numericBuilder.build();
        this.binary = binaryBuilder.build();
    }

    public int getDocId() {
        return this.docId;
    }

    public float getScore() {
        return this.score;
    }

    public Document get() {
        return this.document;
    }

    public Multimap<String, String> getFragments() {
        return this.fragments;
    }

    private static String checkName(SchemaItem item) {
        return ((SchemaItem)Preconditions.checkNotNull((Object)item, (Object)"The schema item must be provided")).getName();
    }

    public FieldValues<Integer> integerValues(String name) {
        return new IntegerValues(name);
    }

    public FieldValues<Long> longValues(String name) {
        return new LongValues(name);
    }

    public FieldValues<Float> floatValues(String name) {
        return new FloatValues(name);
    }

    public FieldValues<Double> doubleValues(String name) {
        return new DoubleValues(name);
    }

    public FieldValues<Boolean> booleanValues(String name) {
        return new BooleanValues(name);
    }

    public FieldValues<InputSupplier<ByteArrayInputStream>> binary(String name) {
        return new BinaryValues(name);
    }

    public FieldValues<ByteString> byteString(String name) {
        return new ByteStringValues(name);
    }

    public FieldValues<UUID> uuid(String name) {
        return new UUIDValues(name);
    }

    public FieldValues<Instant> instant(String name) {
        return new InstantValues(name);
    }

    public FieldValues<String> strings(String name) {
        return new StringValues(name);
    }

    public FieldValues<String> item(TextSchemaItem item) {
        return this.strings(Hit.checkName((SchemaItem)item));
    }

    public FieldValues<Integer> item(IntegerSchemaItem item) {
        return this.integerValues(Hit.checkName((SchemaItem)item));
    }

    public FieldValues<Long> item(LongSchemaItem item) {
        return this.longValues(Hit.checkName((SchemaItem)item));
    }

    public FieldValues<Float> item(FloatSchemaItem item) {
        return this.floatValues(Hit.checkName((SchemaItem)item));
    }

    public FieldValues<Double> item(DoubleSchemaItem item) {
        return this.doubleValues(Hit.checkName((SchemaItem)item));
    }

    public FieldValues<Boolean> item(BooleanSchemaItem item) {
        return this.booleanValues(Hit.checkName((SchemaItem)item));
    }

    public FieldValues<InputSupplier<ByteArrayInputStream>> item(BinarySchemaItem item) {
        return this.binary(Hit.checkName((SchemaItem)item));
    }

    public FieldValues<ByteString> item(ByteStringSchemaItem item) {
        return this.byteString(Hit.checkName((SchemaItem)item));
    }

    public FieldValues<UUID> item(UUIDSchemaItem item) {
        return this.uuid(Hit.checkName((SchemaItem)item));
    }

    public FieldValues<Instant> item(InstantSchemaItem item) {
        return this.instant(Hit.checkName((SchemaItem)item));
    }

    private final class InstantValues
    extends NumericValues<Instant> {
        InstantValues(String name) {
            super(name);
        }

        public Instant apply(Number input) {
            return new Instant(input.longValue());
        }
    }

    private final class UUIDValues
    extends StringBasedValues<UUID> {
        UUIDValues(String name) {
            super(name);
        }

        public UUID apply(Fieldable input) {
            return UUID.fromString(input.stringValue());
        }
    }

    private final class ByteStringValues
    extends AbstractFieldValues<Fieldable, ByteString> {
        ByteStringValues(String name) {
            super(name);
        }

        @Override
        final ImmutableListMultimap<String, Fieldable> map() {
            return Hit.this.binary;
        }

        public ByteString apply(Fieldable input) {
            Preconditions.checkArgument((boolean)input.isBinary());
            return ByteString.copyFrom((byte[])input.getBinaryValue(), (int)input.getBinaryOffset(), (int)input.getBinaryLength());
        }
    }

    private final class BinaryValues
    extends AbstractFieldValues<Fieldable, InputSupplier<ByteArrayInputStream>> {
        BinaryValues(String name) {
            super(name);
        }

        @Override
        final ImmutableListMultimap<String, Fieldable> map() {
            return Hit.this.binary;
        }

        public InputSupplier<ByteArrayInputStream> apply(Fieldable input) {
            Preconditions.checkArgument((boolean)input.isBinary());
            return ByteStreams.newInputStreamSupplier((byte[])input.getBinaryValue(), (int)input.getBinaryOffset(), (int)input.getBinaryLength());
        }
    }

    private final class BooleanValues
    extends AbstractFieldValues<Number, Boolean> {
        BooleanValues(String name) {
            super(name);
        }

        @Override
        final ImmutableListMultimap<String, Number> map() {
            return Hit.this.numeric;
        }

        public Boolean apply(Number input) {
            return input.intValue() != 0;
        }
    }

    private final class DoubleValues
    extends NumericValues<Double> {
        DoubleValues(String name) {
            super(name);
        }

        public Double apply(Number input) {
            if (input instanceof Double) {
                return (Double)input;
            }
            return input.doubleValue();
        }
    }

    private final class FloatValues
    extends NumericValues<Float> {
        FloatValues(String name) {
            super(name);
        }

        public Float apply(Number input) {
            if (input instanceof Float) {
                return (Float)input;
            }
            return Float.valueOf(input.floatValue());
        }
    }

    private final class LongValues
    extends NumericValues<Long> {
        LongValues(String name) {
            super(name);
        }

        public Long apply(Number input) {
            if (input instanceof Long) {
                return (Long)input;
            }
            return input.longValue();
        }
    }

    private final class IntegerValues
    extends NumericValues<Integer> {
        IntegerValues(String name) {
            super(name);
        }

        public Integer apply(Number input) {
            if (input instanceof Integer) {
                return (Integer)input;
            }
            return input.intValue();
        }
    }

    private abstract class NumericValues<T>
    extends AbstractFieldValues<Number, T> {
        NumericValues(String name) {
            super(name);
        }

        @Override
        final ImmutableListMultimap<String, Number> map() {
            return Hit.this.numeric;
        }
    }

    private final class StringValues
    extends StringBasedValues<String> {
        StringValues(String name) {
            super(name);
        }

        public String apply(Fieldable input) {
            return input.stringValue();
        }
    }

    private abstract class StringBasedValues<T>
    extends AbstractFieldValues<Fieldable, T> {
        StringBasedValues(String name) {
            super(name);
        }

        @Override
        final ImmutableListMultimap<String, Fieldable> map() {
            return Hit.this.fields;
        }
    }

    private abstract class AbstractFieldValues<F, T>
    extends AbstractWithFieldNameProperty
    implements FieldValues<T>,
    Function<F, T> {
        private List<T> all;

        AbstractFieldValues(String name) {
            super(name);
            this.all = null;
        }

        @Override
        public final List<T> getAll() {
            if (this.all == null) {
                this.all = ImmutableList.copyOf((Collection)Lists.transform((List)this.map().get((Object)this.getName()), (Function)this));
            }
            return this.all;
        }

        @Override
        public final Optional<T> getOptional() {
            List<T> list = this.getAll();
            if (list.isEmpty()) {
                return Optional.absent();
            }
            return Optional.of(list.get(0));
        }

        @Override
        public final T orNull() {
            return (T)this.getOptional().orNull();
        }

        @Override
        public T or(T defaultValue) {
            return (T)this.getOptional().or(defaultValue);
        }

        @Override
        public final T get() {
            List<T> list = this.getAll();
            if (list.isEmpty()) {
                throw new IllegalArgumentException(String.format("No value for field [%s]", this.getName()));
            }
            return list.get(0);
        }

        abstract ImmutableListMultimap<String, F> map();
    }
}

