/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;

abstract class GenericComparatorSource<T>
extends FieldComparatorSource {
    private static final long serialVersionUID = -5332664958641451859L;
    private final Comparator<T> comparator;

    GenericComparatorSource(Comparator<T> comparator) {
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator, (Object)"The comparator to use must be provided");
    }

    abstract class GenericComparator
    extends FieldComparator<T> {
        private final String field;
        private final boolean reverse;
        private final T[] values;
        private T[] currentReaderValues;
        private T bottom;

        GenericComparator(Class<T> type, String field, boolean reverse, int numHits) {
            this.field = (String)Preconditions.checkNotNull((Object)field);
            this.reverse = reverse;
            Object[] array = (Object[])Array.newInstance(type, numHits);
            this.values = array;
        }

        final String getField() {
            return this.field;
        }

        public final int compareValues(@Nullable T o1, @Nullable T o2) {
            int c = GenericComparatorSource.this.comparator.compare(o1, o2);
            if (this.reverse) {
                return -c;
            }
            return c;
        }

        public final void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValues = this.load(reader, docBase);
        }

        abstract T[] load(IndexReader var1, int var2) throws IOException;

        public final int compare(int slot1, int slot2) {
            return this.compareValues(this.values[slot1], this.values[slot2]);
        }

        public final int compareBottom(int doc) {
            return this.compareValues(this.bottom, this.currentReaderValues[doc]);
        }

        public final void copy(int slot, int doc) {
            this.values[slot] = this.currentReaderValues[doc];
        }

        public final void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public T value(int slot) {
            return this.values[slot];
        }
    }
}

