/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.document;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Set;
import net.conquiris.schema.SchemaItem;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;

public final class FieldSelectors {
    private FieldSelectors() {
        throw new AssertionError();
    }

    public static FieldSelector loadFields(Iterable<String> fieldsToLoad, Iterable<String> fieldsToLoadLazily) {
        ImmutableSet eager = ImmutableSet.copyOf(fieldsToLoad);
        ImmutableSet lazy = ImmutableSet.copyOf(fieldsToLoadLazily);
        return new SetBasedFieldSelector((Set)eager, (Set)lazy);
    }

    public static FieldSelector loadFields(Iterable<String> fieldsToLoad) {
        return FieldSelectors.loadFields(fieldsToLoad, (Iterable<String>)ImmutableSet.of());
    }

    public static FieldSelector loadFields(String ... fieldsToLoad) {
        return FieldSelectors.loadFields(Arrays.asList(fieldsToLoad));
    }

    public static FieldSelector loadItems(Iterable<? extends SchemaItem> itemsToLoad, Iterable<? extends SchemaItem> itemsToLoadLazily) {
        return FieldSelectors.loadFields(Iterables.transform(itemsToLoad, (Function)SchemaItem.NAME), Iterables.transform(itemsToLoadLazily, (Function)SchemaItem.NAME));
    }

    public static FieldSelector loadItems(Iterable<? extends SchemaItem> itemsToLoad) {
        return FieldSelectors.loadFields(Iterables.transform(itemsToLoad, (Function)SchemaItem.NAME), (Iterable<String>)ImmutableSet.of());
    }

    public static FieldSelector loadItems(SchemaItem ... itemsToLoad) {
        return FieldSelectors.loadItems(Arrays.asList(itemsToLoad));
    }
}

