/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.document;

import com.google.common.base.Preconditions;
import net.conquiris.schema.IsIndexedFlag;
import net.conquiris.schema.IsStoredFlag;
import net.conquiris.schema.SchemaItem;
import net.derquinse.common.reflect.This;
import org.apache.lucene.document.Field;

public abstract class FieldBuilder<B extends FieldBuilder<B>>
extends This<B>
implements IsStoredFlag,
IsIndexedFlag {
    private final String name;

    FieldBuilder(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"The field name must be provided");
    }

    FieldBuilder(SchemaItem item) {
        Preconditions.checkNotNull((Object)item, (Object)"The schema item must be provided");
        this.name = (String)Preconditions.checkNotNull((Object)item.getName(), (Object)"The field name must be provided");
    }

    final String name() {
        return this.name;
    }

    final Field.Store fieldStore() {
        return this.isStored() ? Field.Store.YES : Field.Store.NO;
    }

    final Field.Store checkUsed() {
        Preconditions.checkState((this.isIndexed() || this.isStored() ? 1 : 0) != 0, (Object)"Field neither stored nor indexed");
        return this.fieldStore();
    }
}

