/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import net.conquiris.schema.SchemaItem;
import net.derquinse.common.base.NotInstantiable;
import org.apache.lucene.index.Term;

abstract class SearchSupport
extends NotInstantiable {
    SearchSupport() {
    }

    static Term checkTerm(Term term) {
        return (Term)Preconditions.checkNotNull((Object)term, (Object)"The term must be provided");
    }

    static String checkField(String field) {
        return (String)Preconditions.checkNotNull((Object)field, (Object)"The field name must be provided");
    }

    static void checkRange(Range<?> range) {
        Preconditions.checkNotNull(range, (Object)"The value range must be provided");
    }

    static <T extends Comparable<T>> T min(Range<? extends T> range) {
        if (range.hasLowerBound()) {
            return (T)range.lowerEndpoint();
        }
        return null;
    }

    static <T extends Comparable<T>> T max(Range<? extends T> range) {
        if (range.hasUpperBound()) {
            return (T)range.upperEndpoint();
        }
        return null;
    }

    static boolean minIncluded(Range<?> range) {
        return range.hasLowerBound() && range.lowerBoundType() == BoundType.CLOSED;
    }

    static boolean maxIncluded(Range<?> range) {
        return range.hasUpperBound() && range.upperBoundType() == BoundType.CLOSED;
    }

    static String checkItem(SchemaItem field) {
        return ((SchemaItem)Preconditions.checkNotNull((Object)field, (Object)"The term field schema item must be provided")).getName();
    }
}

