/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import java.io.IOException;
import java.util.Comparator;
import net.conquiris.lucene.search.GenericComparatorSource;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.Bits;

final class LongComparatorSource
extends GenericComparatorSource<Long> {
    private static final long serialVersionUID = 6482544719528657501L;

    LongComparatorSource(Comparator<Long> comparator) {
        super(comparator);
    }

    public FieldComparator<Long> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        return new LongComparator(fieldname, reversed, numHits);
    }

    final class LongComparator
    extends GenericComparatorSource.GenericComparator {
        LongComparator(String field, boolean reverse, int numHits) {
            super(Long.class, field, reverse, numHits);
        }

        Long[] load(IndexReader reader, int docBase) throws IOException {
            long[] p = FieldCache.DEFAULT.getLongs(reader, this.getField(), FieldCache.NUMERIC_UTILS_LONG_PARSER, true);
            Bits docsWithField = FieldCache.DEFAULT.getDocsWithField(reader, this.getField());
            if (docsWithField instanceof Bits.MatchAllBits) {
                docsWithField = null;
            }
            int n = p.length;
            Long[] values = new Long[n];
            for (int i = 0; i < n; ++i) {
                long v = p[i];
                values[i] = docsWithField != null && v == 0L && !docsWithField.get(i) ? null : Long.valueOf(v);
            }
            return values;
        }
    }
}

