/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public final class GuavaCachingFilter
extends Filter {
    private static final long serialVersionUID = -3469818482930960618L;
    private final Filter filter;
    private final Cache<Object, DocIdSet> cache;

    public static <K, V extends Filter> LoadingCache<K, Filter> cachingFactory(final CacheLoader<K, V> loader, int primarySize, long primaryDuration, TimeUnit primaryUnit, final int secondarySize, final long secondaryDuration, final TimeUnit secondaryUnit) {
        Preconditions.checkArgument((primarySize >= 0 && primaryDuration >= 0L && secondarySize >= 0 && secondaryDuration >= 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)primaryUnit));
        Preconditions.checkNotNull((Object)((Object)secondaryUnit));
        CacheLoader primaryLoader = new CacheLoader<K, Filter>(){

            public Filter load(K key) throws Exception {
                return new GuavaCachingFilter((Filter)loader.load(key), secondarySize, secondaryDuration, secondaryUnit);
            }
        };
        return CacheBuilder.newBuilder().softValues().maximumSize((long)primarySize).expireAfterAccess(primaryDuration, primaryUnit).build(primaryLoader);
    }

    public static GuavaCachingFilter of(Filter filter, int size, long duration, TimeUnit unit) {
        return new GuavaCachingFilter(filter, size, duration, unit);
    }

    public static GuavaCachingFilter of(Filter filter) {
        return GuavaCachingFilter.of(filter, 100, 10L, TimeUnit.MINUTES);
    }

    private GuavaCachingFilter(Filter filter, int size, long duration, TimeUnit unit) {
        this.filter = (Filter)Preconditions.checkNotNull((Object)filter, (Object)"The filter to cache must be provided");
        this.cache = CacheBuilder.newBuilder().softValues().maximumSize((long)size).expireAfterAccess(duration, unit).build();
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        Object key = reader.hasDeletions() ? reader.getDeletesCacheKey() : reader.getCoreCacheKey();
        try {
            return (DocIdSet)this.cache.get(key, (Callable)new Loader(reader));
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (t instanceof UncheckedExecutionException) {
                throw (UncheckedExecutionException)t;
            }
            throw new UncheckedExecutionException(cause);
        }
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    public String toString() {
        return "GuavaCachingFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof GuavaCachingFilter)) {
            return false;
        }
        return this.filter.equals(((GuavaCachingFilter)((Object)o)).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }

    private final class Loader
    implements Callable<DocIdSet> {
        private final IndexReader reader;

        Loader(IndexReader reader) {
            this.reader = (IndexReader)Preconditions.checkNotNull((Object)reader, (Object)"The index reader must be provided");
        }

        @Override
        public DocIdSet call() throws Exception {
            return this.docIdSetToCache(GuavaCachingFilter.this.filter.getDocIdSet(this.reader));
        }

        private DocIdSet docIdSetToCache(DocIdSet docIdSet) throws IOException {
            if (docIdSet == null) {
                return DocIdSet.EMPTY_DOCIDSET;
            }
            if (docIdSet.isCacheable()) {
                return docIdSet;
            }
            DocIdSetIterator it = docIdSet.iterator();
            if (it == null) {
                return DocIdSet.EMPTY_DOCIDSET;
            }
            FixedBitSet bits = new FixedBitSet(this.reader.maxDoc());
            bits.or(it);
            return bits;
        }
    }
}

