/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import java.io.IOException;
import java.util.Comparator;
import net.conquiris.lucene.search.GenericComparatorSource;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.Bits;

final class FloatComparatorSource
extends GenericComparatorSource<Float> {
    private static final long serialVersionUID = 6482544719528657501L;

    FloatComparatorSource(Comparator<Float> comparator) {
        super(comparator);
    }

    public FieldComparator<Float> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        return new FloatComparator(fieldname, reversed, numHits);
    }

    final class FloatComparator
    extends GenericComparatorSource.GenericComparator {
        FloatComparator(String field, boolean reverse, int numHits) {
            super(FloatComparatorSource.this, Float.class, field, reverse, numHits);
        }

        Float[] load(IndexReader reader, int docBase) throws IOException {
            float[] p = FieldCache.DEFAULT.getFloats(reader, this.getField(), FieldCache.NUMERIC_UTILS_FLOAT_PARSER, true);
            Bits docsWithField = FieldCache.DEFAULT.getDocsWithField(reader, this.getField());
            if (docsWithField instanceof Bits.MatchAllBits) {
                docsWithField = null;
            }
            int n = p.length;
            Float[] values = new Float[n];
            for (int i = 0; i < n; ++i) {
                float v = p[i];
                values[i] = docsWithField != null && v == 0.0f && !docsWithField.get(i) ? null : Float.valueOf(v);
            }
            return values;
        }
    }
}

