/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import java.io.IOException;
import java.util.Comparator;
import net.conquiris.lucene.search.GenericComparatorSource;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.Bits;

final class DoubleComparatorSource
extends GenericComparatorSource<Double> {
    private static final long serialVersionUID = 6482544719528657501L;

    DoubleComparatorSource(Comparator<Double> comparator) {
        super(comparator);
    }

    public FieldComparator<Double> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        return new DoubleComparator(fieldname, reversed, numHits);
    }

    final class DoubleComparator
    extends GenericComparatorSource.GenericComparator {
        DoubleComparator(String field, boolean reverse, int numHits) {
            super(DoubleComparatorSource.this, Double.class, field, reverse, numHits);
        }

        Double[] load(IndexReader reader, int docBase) throws IOException {
            double[] p = FieldCache.DEFAULT.getDoubles(reader, this.getField(), FieldCache.NUMERIC_UTILS_DOUBLE_PARSER, true);
            Bits docsWithField = FieldCache.DEFAULT.getDocsWithField(reader, this.getField());
            if (docsWithField instanceof Bits.MatchAllBits) {
                docsWithField = null;
            }
            int n = p.length;
            Double[] values = new Double[n];
            for (int i = 0; i < n; ++i) {
                double v = p[i];
                values[i] = docsWithField != null && v == 0.0 && !docsWithField.get(i) ? null : Double.valueOf(v);
            }
            return values;
        }
    }
}

