/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.conquiris.lucene.search.SearchSupport;
import net.conquiris.schema.BooleanSchemaItem;
import net.conquiris.schema.DoubleSchemaItem;
import net.conquiris.schema.FloatSchemaItem;
import net.conquiris.schema.InstantSchemaItem;
import net.conquiris.schema.IntegerSchemaItem;
import net.conquiris.schema.LongSchemaItem;
import net.conquiris.schema.SchemaItem;
import net.conquiris.schema.TextSchemaItem;
import net.derquinse.common.base.Builder;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public final class SortBuilder
implements Builder<Sort> {
    private final List<SortField> fields = Lists.newLinkedList();

    private SortBuilder() {
    }

    private static String checkSortable(SchemaItem item) {
        String name = SearchSupport.checkItem(item);
        Preconditions.checkArgument((boolean)item.isIndexed(), (String)"The provided field [%s] is not indexed", (Object[])new Object[]{name});
        return name;
    }

    public static SortField field(TextSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 3, reverse);
    }

    public static SortField field(TextSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(IntegerSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 4, reverse);
    }

    public static SortField field(IntegerSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(LongSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 6, reverse);
    }

    public static SortField field(LongSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(FloatSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 5, reverse);
    }

    public static SortField field(FloatSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(DoubleSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 7, reverse);
    }

    public static SortField field(DoubleSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(BooleanSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 4, reverse);
    }

    public static SortField field(BooleanSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public static SortField field(InstantSchemaItem field, boolean reverse) {
        return new SortField(SortBuilder.checkSortable((SchemaItem)field), 6, reverse);
    }

    public static SortField field(InstantSchemaItem field) {
        return SortBuilder.field(field, false);
    }

    public Sort build() {
        if (this.fields.isEmpty()) {
            return new Sort();
        }
        SortField[] array = new SortField[this.fields.size()];
        this.fields.toArray(array);
        return new Sort(array);
    }

    public SortBuilder add(SortField field) {
        this.fields.add((SortField)Preconditions.checkNotNull((Object)field));
        return this;
    }

    public SortBuilder add(Iterable<? extends SortField> fields) {
        for (SortField sortField : fields) {
            this.add(sortField);
        }
        return this;
    }

    public SortBuilder add(SortField ... fields) {
        return this.add(Arrays.asList(fields));
    }

    public SortBuilder add(TextSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(TextSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(IntegerSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(IntegerSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(LongSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(LongSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(FloatSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(FloatSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(DoubleSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(DoubleSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(BooleanSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(BooleanSchemaItem field) {
        return this.add(field, false);
    }

    public SortBuilder add(InstantSchemaItem field, boolean reverse) {
        return this.add(SortBuilder.field(field, reverse));
    }

    public SortBuilder add(InstantSchemaItem field) {
        return this.add(field, false);
    }
}

