/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.search;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import java.text.Collator;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.conquiris.lucene.search.SearchSupport;
import net.conquiris.schema.DoubleSchemaItem;
import net.conquiris.schema.FloatSchemaItem;
import net.conquiris.schema.InstantSchemaItem;
import net.conquiris.schema.IntegerSchemaItem;
import net.conquiris.schema.LongSchemaItem;
import net.conquiris.schema.SchemaItem;
import net.conquiris.schema.TextSchemaItem;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TermsFilter;
import org.joda.time.ReadableInstant;

public final class Filters
extends SearchSupport {
    private Filters() {
    }

    public static TermsFilter terms(Iterable<Term> terms) {
        Preconditions.checkNotNull(terms);
        TermsFilter f = new TermsFilter();
        for (Term t : terms) {
            f.addTerm(t);
        }
        return f;
    }

    public static TermsFilter terms(Term ... terms) {
        return Filters.terms(Arrays.asList(terms));
    }

    public static <T> TermsFilter terms(Function<? super T, Term> termBuilder, Iterable<T> values) {
        return Filters.terms(Iterables.transform(values, termBuilder));
    }

    public static <T> TermsFilter terms(Function<? super T, Term> termBuilder, T ... values) {
        return Filters.terms(termBuilder, Arrays.asList(values));
    }

    public static TermRangeFilter termRange(String field, @Nullable String lowerTerm, @Nullable String upperTerm, boolean includeLower, boolean includeUpper, Collator collator) {
        Filters.checkField(field);
        Preconditions.checkArgument((lowerTerm != null || upperTerm != null ? 1 : 0) != 0, (Object)"At least one limit must be provided");
        return new TermRangeFilter(field, lowerTerm, upperTerm, includeLower && lowerTerm != null, includeUpper && upperTerm != null, collator);
    }

    public static TermRangeFilter termRange(String field, @Nullable String lowerTerm, @Nullable String upperTerm, boolean includeLower, boolean includeUpper) {
        return Filters.termRange(field, lowerTerm, upperTerm, includeLower, includeUpper, null);
    }

    public static TermRangeFilter termRange(TextSchemaItem field, @Nullable String lowerTerm, @Nullable String upperTerm, boolean includeLower, boolean includeUpper, Collator collator) {
        return Filters.termRange(Filters.checkItem((SchemaItem)field), lowerTerm, upperTerm, includeLower, includeUpper, collator);
    }

    public static TermRangeFilter termRange(TextSchemaItem field, @Nullable String lowerTerm, @Nullable String upperTerm, boolean includeLower, boolean includeUpper) {
        return Filters.termRange(Filters.checkItem((SchemaItem)field), lowerTerm, upperTerm, includeLower, includeUpper);
    }

    public static TermRangeFilter termRange(String field, Range<String> range, Collator collator) {
        Filters.checkField(field);
        Filters.checkRange(range);
        return Filters.termRange(field, Filters.min(range), Filters.max(range), Filters.minIncluded(range), Filters.maxIncluded(range), collator);
    }

    public static TermRangeFilter termRange(String field, Range<String> range) {
        Filters.checkField(field);
        Filters.checkRange(range);
        return Filters.termRange(field, Filters.min(range), Filters.max(range), Filters.minIncluded(range), Filters.maxIncluded(range));
    }

    public static TermRangeFilter termRange(TextSchemaItem field, Range<String> range, Collator collator) {
        return Filters.termRange(Filters.checkItem((SchemaItem)field), range, collator);
    }

    public static TermRangeFilter termRange(TextSchemaItem field, Range<String> range) {
        return Filters.termRange(Filters.checkItem((SchemaItem)field), range);
    }

    public static NumericRangeFilter<Integer> intRange(String field, @Nullable Integer min, @Nullable Integer max, boolean minInclusive, boolean maxInclusive) {
        Filters.checkField(field);
        Preconditions.checkArgument((min != null || max != null ? 1 : 0) != 0, (Object)"At least one limit must be provided");
        return NumericRangeFilter.newIntRange((String)field, (Integer)min, (Integer)max, (boolean)minInclusive, (boolean)maxInclusive);
    }

    public static NumericRangeFilter<Integer> intRange(IntegerSchemaItem field, @Nullable Integer min, @Nullable Integer max, boolean minInclusive, boolean maxInclusive) {
        return Filters.intRange(Filters.checkItem((SchemaItem)field), min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeFilter<Integer> intRange(String field, Range<Integer> range) {
        Filters.checkField(field);
        Filters.checkRange(range);
        return Filters.intRange(field, Filters.min(range), Filters.max(range), Filters.minIncluded(range), Filters.maxIncluded(range));
    }

    public static NumericRangeFilter<Integer> intRange(IntegerSchemaItem field, Range<Integer> range) {
        return Filters.intRange(Filters.checkItem((SchemaItem)field), range);
    }

    public static NumericRangeFilter<Long> longRange(String field, @Nullable Long min, @Nullable Long max, boolean minInclusive, boolean maxInclusive) {
        Filters.checkField(field);
        Preconditions.checkArgument((min != null || max != null ? 1 : 0) != 0, (Object)"At least one limit must be provided");
        return NumericRangeFilter.newLongRange((String)field, (Long)min, (Long)max, (boolean)minInclusive, (boolean)maxInclusive);
    }

    public static NumericRangeFilter<Long> longRange(LongSchemaItem field, @Nullable Long min, @Nullable Long max, boolean minInclusive, boolean maxInclusive) {
        return Filters.longRange(Filters.checkItem((SchemaItem)field), min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeFilter<Long> longRange(String field, Range<Long> range) {
        Filters.checkField(field);
        Filters.checkRange(range);
        return Filters.longRange(field, Filters.min(range), Filters.max(range), Filters.minIncluded(range), Filters.maxIncluded(range));
    }

    public static NumericRangeFilter<Long> longRange(LongSchemaItem field, Range<Long> range) {
        return Filters.longRange(Filters.checkItem((SchemaItem)field), range);
    }

    public static NumericRangeFilter<Float> floatRange(String field, @Nullable Float min, @Nullable Float max, boolean minInclusive, boolean maxInclusive) {
        Filters.checkField(field);
        Preconditions.checkArgument((min != null || max != null ? 1 : 0) != 0, (Object)"At least one limit must be provided");
        return NumericRangeFilter.newFloatRange((String)field, (Float)min, (Float)max, (boolean)minInclusive, (boolean)maxInclusive);
    }

    public static NumericRangeFilter<Float> floatRange(FloatSchemaItem field, @Nullable Float min, @Nullable Float max, boolean minInclusive, boolean maxInclusive) {
        return Filters.floatRange(Filters.checkItem((SchemaItem)field), min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeFilter<Float> floatRange(String field, Range<Float> range) {
        Filters.checkField(field);
        Filters.checkRange(range);
        return Filters.floatRange(field, Filters.min(range), Filters.max(range), Filters.minIncluded(range), Filters.maxIncluded(range));
    }

    public static NumericRangeFilter<Float> floatRange(FloatSchemaItem field, Range<Float> range) {
        return Filters.floatRange(Filters.checkItem((SchemaItem)field), range);
    }

    public static NumericRangeFilter<Double> doubleRange(String field, @Nullable Double min, @Nullable Double max, boolean minInclusive, boolean maxInclusive) {
        Filters.checkField(field);
        Preconditions.checkArgument((min != null || max != null ? 1 : 0) != 0, (Object)"At least one limit must be provided");
        return NumericRangeFilter.newDoubleRange((String)field, (Double)min, (Double)max, (boolean)minInclusive, (boolean)maxInclusive);
    }

    public static NumericRangeFilter<Double> doubleRange(DoubleSchemaItem field, @Nullable Double min, @Nullable Double max, boolean minInclusive, boolean maxInclusive) {
        return Filters.doubleRange(Filters.checkItem((SchemaItem)field), min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeFilter<Double> doubleRange(String field, Range<Double> range) {
        Filters.checkField(field);
        Filters.checkRange(range);
        return Filters.doubleRange(field, Filters.min(range), Filters.max(range), Filters.minIncluded(range), Filters.maxIncluded(range));
    }

    public static NumericRangeFilter<Double> doubleRange(DoubleSchemaItem field, Range<Double> range) {
        return Filters.doubleRange(Filters.checkItem((SchemaItem)field), range);
    }

    public static NumericRangeFilter<Long> instantRange(String field, @Nullable ReadableInstant min, @Nullable ReadableInstant max, boolean minInclusive, boolean maxInclusive) {
        Filters.checkField(field);
        Preconditions.checkArgument((min != null || max != null ? 1 : 0) != 0, (Object)"At least one limit must be provided");
        return NumericRangeFilter.newLongRange((String)field, (Long)(min != null ? Long.valueOf(min.getMillis()) : null), (Long)(max != null ? Long.valueOf(max.getMillis()) : null), (boolean)minInclusive, (boolean)maxInclusive);
    }

    public static NumericRangeFilter<Long> instantRange(InstantSchemaItem field, @Nullable ReadableInstant min, @Nullable ReadableInstant max, boolean minInclusive, boolean maxInclusive) {
        return Filters.instantRange(Filters.checkItem((SchemaItem)field), min, max, minInclusive, maxInclusive);
    }

    public static NumericRangeFilter<Long> instantRange(String field, Range<? extends ReadableInstant> range) {
        Filters.checkField(field);
        Filters.checkRange(range);
        return Filters.instantRange(field, Filters.min(range), Filters.max(range), Filters.minIncluded(range), Filters.maxIncluded(range));
    }

    public static NumericRangeFilter<Long> instantRange(InstantSchemaItem field, Range<? extends ReadableInstant> range) {
        return Filters.instantRange(Filters.checkItem((SchemaItem)field), range);
    }

    public static BooleanFilter addClauses(BooleanFilter filter, BooleanClause.Occur occur, Iterable<? extends Filter> filters) {
        Preconditions.checkNotNull((Object)filter, (Object)"The destination boolean filter must be provided");
        Preconditions.checkNotNull((Object)occur, (Object)"The occurrence specification must be provided");
        ImmutableList list = ImmutableList.copyOf(filters);
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"At least one filter must be provided");
        for (Filter filter2 : filters) {
            filter.add(filter2, occur);
        }
        return filter;
    }

    public static BooleanFilter addClauses(BooleanFilter filter, BooleanClause.Occur occur, Filter ... filters) {
        return Filters.addClauses(filter, occur, Arrays.asList(filters));
    }

    public static BooleanFilter booleanFilter(BooleanClause.Occur occur, Iterable<? extends Filter> filters) {
        return Filters.addClauses(new BooleanFilter(), occur, filters);
    }

    public static BooleanFilter booleanFilter(BooleanClause.Occur occur, Filter ... filters) {
        return Filters.addClauses(new BooleanFilter(), occur, filters);
    }
}

