/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.index;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.UUID;
import net.conquiris.schema.BooleanSchemaItem;
import net.conquiris.schema.DoubleSchemaItem;
import net.conquiris.schema.FloatSchemaItem;
import net.conquiris.schema.InstantSchemaItem;
import net.conquiris.schema.IntegerSchemaItem;
import net.conquiris.schema.LongSchemaItem;
import net.conquiris.schema.SchemaItem;
import net.conquiris.schema.TextSchemaItem;
import net.conquiris.schema.UUIDSchemaItem;
import net.derquinse.common.base.NotInstantiable;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.NumericUtils;
import org.joda.time.ReadableInstant;

public final class Terms
extends NotInstantiable {
    private Terms() {
    }

    private static String checkField(String field) {
        return (String)Preconditions.checkNotNull((Object)field, (Object)"The term field name must be provided");
    }

    private static <T> T checkValue(T value) {
        return (T)Preconditions.checkNotNull(value, (Object)"The term value must be provided");
    }

    private static String checkItem(SchemaItem field) {
        return ((SchemaItem)Preconditions.checkNotNull((Object)field, (Object)"The term field schema item must be provided")).getName();
    }

    public static Term term(String field, String value) {
        return new Term(Terms.checkField(field), Terms.checkValue(value));
    }

    public static Term term(String field, int value) {
        return Terms.term(field, NumericUtils.intToPrefixCoded((int)value));
    }

    public static Term term(String field, long value) {
        return Terms.term(field, NumericUtils.longToPrefixCoded((long)value));
    }

    public static Term term(String field, float value) {
        return Terms.term(field, NumericUtils.floatToPrefixCoded((float)value));
    }

    public static Term term(String field, double value) {
        return Terms.term(field, NumericUtils.doubleToPrefixCoded((double)value));
    }

    public static Term term(String field, boolean value) {
        return Terms.term(field, value ? 1 : 0);
    }

    public static Term term(String field, UUID value) {
        return Terms.term(field, Terms.checkValue(value).toString());
    }

    public static Term term(String field, ReadableInstant value) {
        return Terms.term(field, Terms.checkValue(value).getMillis());
    }

    public static Term term(TextSchemaItem field, String value) {
        return Terms.term(Terms.checkItem((SchemaItem)field), value);
    }

    public static Term term(IntegerSchemaItem field, int value) {
        return Terms.term(Terms.checkItem((SchemaItem)field), value);
    }

    public static Term term(LongSchemaItem field, long value) {
        return Terms.term(Terms.checkItem((SchemaItem)field), value);
    }

    public static Term term(FloatSchemaItem field, float value) {
        return Terms.term(Terms.checkItem((SchemaItem)field), value);
    }

    public static Term term(DoubleSchemaItem field, double value) {
        return Terms.term(Terms.checkItem((SchemaItem)field), value);
    }

    public static Term term(BooleanSchemaItem field, boolean value) {
        return Terms.term(Terms.checkItem((SchemaItem)field), value);
    }

    public static Term term(UUIDSchemaItem field, UUID value) {
        return Terms.term(Terms.checkItem((SchemaItem)field), value);
    }

    public static Term term(InstantSchemaItem field, ReadableInstant value) {
        return Terms.term(Terms.checkItem((SchemaItem)field), value);
    }

    public static Function<String, Term> stringTermBuilder(String field) {
        return new StringTermBuilder(field);
    }

    public static Function<Integer, Term> intTermBuilder(String field) {
        return new IntTermBuilder(field);
    }

    public static Function<Long, Term> longTermBuilder(String field) {
        return new LongTermBuilder(field);
    }

    public static Function<Float, Term> floatTermBuilder(String field) {
        return new FloatTermBuilder(field);
    }

    public static Function<Double, Term> doubleTermBuilder(String field) {
        return new DoubleTermBuilder(field);
    }

    public static Function<Boolean, Term> booleanTermBuilder(String field) {
        return new BooleanTermBuilder(field);
    }

    public static Function<ReadableInstant, Term> instantTermBuilder(String field) {
        return new InstantTermBuilder(field);
    }

    public static Function<UUID, Term> uuidTermBuilder(String field) {
        return new UUIDTermBuilder(field);
    }

    public static Function<String, Term> termBuilder(TextSchemaItem field) {
        return Terms.stringTermBuilder(Terms.checkItem((SchemaItem)field));
    }

    public static Function<Integer, Term> termBuilder(IntegerSchemaItem field) {
        return Terms.intTermBuilder(Terms.checkItem((SchemaItem)field));
    }

    public static Function<Long, Term> termBuilder(LongSchemaItem field) {
        return Terms.longTermBuilder(Terms.checkItem((SchemaItem)field));
    }

    public static Function<Float, Term> termBuilder(FloatSchemaItem field) {
        return Terms.floatTermBuilder(Terms.checkItem((SchemaItem)field));
    }

    public static Function<Double, Term> termBuilder(DoubleSchemaItem field) {
        return Terms.doubleTermBuilder(Terms.checkItem((SchemaItem)field));
    }

    public static Function<Boolean, Term> termBuilder(BooleanSchemaItem field) {
        return Terms.booleanTermBuilder(Terms.checkItem((SchemaItem)field));
    }

    public static Function<ReadableInstant, Term> termBuilder(InstantSchemaItem field) {
        return Terms.instantTermBuilder(Terms.checkItem((SchemaItem)field));
    }

    public static Function<UUID, Term> termBuilder(UUIDSchemaItem field) {
        return Terms.uuidTermBuilder(Terms.checkItem((SchemaItem)field));
    }

    private static final class InstantTermBuilder
    extends TermBuilder<ReadableInstant> {
        InstantTermBuilder(String field) {
            super(field);
        }

        public Term apply(ReadableInstant input) {
            return Terms.term(this.field, input);
        }
    }

    private static final class UUIDTermBuilder
    extends TermBuilder<UUID> {
        UUIDTermBuilder(String field) {
            super(field);
        }

        public Term apply(UUID input) {
            return Terms.term(this.field, input);
        }
    }

    private static final class DoubleTermBuilder
    extends TermBuilder<Double> {
        DoubleTermBuilder(String field) {
            super(field);
        }

        public Term apply(Double input) {
            return Terms.term(this.field, (double)input);
        }
    }

    private static final class BooleanTermBuilder
    extends TermBuilder<Boolean> {
        BooleanTermBuilder(String field) {
            super(field);
        }

        public Term apply(Boolean input) {
            return Terms.term(this.field, (boolean)input);
        }
    }

    private static final class FloatTermBuilder
    extends TermBuilder<Float> {
        FloatTermBuilder(String field) {
            super(field);
        }

        public Term apply(Float input) {
            return Terms.term(this.field, input.floatValue());
        }
    }

    private static final class LongTermBuilder
    extends TermBuilder<Long> {
        LongTermBuilder(String field) {
            super(field);
        }

        public Term apply(Long input) {
            return Terms.term(this.field, (long)input);
        }
    }

    private static final class IntTermBuilder
    extends TermBuilder<Integer> {
        IntTermBuilder(String field) {
            super(field);
        }

        public Term apply(Integer input) {
            return Terms.term(this.field, (int)input);
        }
    }

    private static final class StringTermBuilder
    extends TermBuilder<String> {
        StringTermBuilder(String field) {
            super(field);
        }

        public Term apply(String input) {
            return Terms.term(this.field, input);
        }
    }

    private static abstract class TermBuilder<F>
    implements Function<F, Term> {
        final String field;

        TermBuilder(String field) {
            this.field = Terms.checkField(field);
        }
    }
}

