/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.io.Reader;
import java.util.UUID;
import net.conquiris.lucene.document.BaseBinaryFieldBuilder;
import net.conquiris.lucene.document.BaseNumericFieldBuilder;
import net.conquiris.lucene.document.BaseTextFieldBuilder;
import net.conquiris.lucene.document.BinaryFieldAdder;
import net.conquiris.lucene.document.NumericFieldAdder;
import net.conquiris.lucene.document.TextFieldAdder;
import net.conquiris.schema.BinarySchemaItem;
import net.conquiris.schema.DoubleSchemaItem;
import net.conquiris.schema.FloatSchemaItem;
import net.conquiris.schema.InstantSchemaItem;
import net.conquiris.schema.IntegerSchemaItem;
import net.conquiris.schema.LongSchemaItem;
import net.conquiris.schema.NumericSchemaItem;
import net.conquiris.schema.SchemaItem;
import net.conquiris.schema.StreamSchemaItem;
import net.conquiris.schema.TextSchemaItem;
import net.conquiris.schema.UUIDSchemaItem;
import net.derquinse.common.base.Builder;
import net.derquinse.common.reflect.This;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.joda.time.ReadableInstant;

public abstract class BaseDocumentBuilder<B extends BaseDocumentBuilder<B>>
extends This<B>
implements Builder<Document> {
    private Document document = new Document();
    private final Multiset<String> fields = HashMultiset.create();

    protected BaseDocumentBuilder() {
    }

    private void checkAvailable() {
        Preconditions.checkState((this.document != null ? 1 : 0) != 0, (Object)"Document already built");
    }

    protected void complete(Multiset<String> fields) {
    }

    public final Document build() {
        this.checkAvailable();
        this.complete((Multiset<String>)Multisets.unmodifiableMultiset(this.fields));
        Document d = this.document;
        this.document = null;
        return d;
    }

    public final B add(Fieldable fieldable) {
        this.checkAvailable();
        Preconditions.checkNotNull((Object)fieldable, (Object)"The fieldable to add must be provided");
        this.fields.add((Object)fieldable.name());
        this.document.add(fieldable);
        return (B)((Object)((BaseDocumentBuilder)this.thisValue()));
    }

    public final B add(Iterable<? extends Fieldable> fieldables) {
        this.checkAvailable();
        Preconditions.checkNotNull(fieldables, (Object)"The fieldables to add must be provided");
        for (Fieldable fieldable : fieldables) {
            this.add(fieldable);
        }
        return (B)((Object)((BaseDocumentBuilder)this.thisValue()));
    }

    public final DocNumericFieldBuilder numeric(String name) {
        return new DocNumericFieldBuilder(name);
    }

    public final DocTextFieldBuilder text(String name) {
        return new DocTextFieldBuilder(name);
    }

    public final DocBinaryFieldBuilder binary(String name) {
        return new DocBinaryFieldBuilder(name);
    }

    private void checkItem(SchemaItem item) {
        Preconditions.checkNotNull((Object)item, (Object)"The schema item must be provided");
        String name = item.getName();
        Preconditions.checkState((this.fields.count((Object)name) < item.getMaxOccurs() ? 1 : 0) != 0, (String)"Maximum number of occurrences for field [%s] reached", (Object[])new Object[]{name});
    }

    private DocNumericFieldBuilder numeric(NumericSchemaItem<?> item) {
        this.checkItem((SchemaItem)item);
        return new DocNumericFieldBuilder(item);
    }

    private DocTextFieldBuilder text(TextSchemaItem item) {
        this.checkItem((SchemaItem)item);
        return new DocTextFieldBuilder(item);
    }

    private DocBinaryFieldBuilder binary(BinarySchemaItem item) {
        this.checkItem((SchemaItem)item);
        return new DocBinaryFieldBuilder(item);
    }

    public final B add(IntegerSchemaItem item, int value) {
        return this.numeric((NumericSchemaItem<?>)item).add(value);
    }

    public final B add(LongSchemaItem item, long value) {
        return this.numeric((NumericSchemaItem<?>)item).add(value);
    }

    public final B add(FloatSchemaItem item, float value) {
        return this.numeric((NumericSchemaItem<?>)item).add(value);
    }

    public final B add(DoubleSchemaItem item, double value) {
        return this.numeric((NumericSchemaItem<?>)item).add(value);
    }

    public final B add(TextSchemaItem item, String value) {
        return this.text(item).add(value);
    }

    public final B add(StreamSchemaItem item, Reader reader) {
        return this.text((TextSchemaItem)item).add(reader);
    }

    public final B add(StreamSchemaItem item, TokenStream tokenStream) {
        return this.text((TextSchemaItem)item).add(tokenStream);
    }

    public final B add(UUIDSchemaItem item, UUID value) {
        return this.text((TextSchemaItem)item).add(value.toString());
    }

    public final B add(BinarySchemaItem item, byte[] value) {
        return this.binary(item).add(value);
    }

    public final B add(InstantSchemaItem item, ReadableInstant value) {
        return this.numeric((NumericSchemaItem<?>)item).add(value.getMillis());
    }

    public final class DocBinaryFieldBuilder
    extends BaseBinaryFieldBuilder<DocBinaryFieldBuilder>
    implements BinaryFieldAdder<B> {
        private DocBinaryFieldBuilder(String name) {
            super(name);
        }

        private DocBinaryFieldBuilder(BinarySchemaItem item) {
            super(item);
        }

        @Override
        public B add(byte[] value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }
    }

    public final class DocTextFieldBuilder
    extends BaseTextFieldBuilder<DocTextFieldBuilder>
    implements TextFieldAdder<B> {
        private DocTextFieldBuilder(String name) {
            super(name);
        }

        private DocTextFieldBuilder(TextSchemaItem item) {
            super(item);
        }

        @Override
        public B add(String value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }

        @Override
        public B add(Reader reader) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(reader));
        }

        @Override
        public B add(TokenStream tokenStream) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(tokenStream));
        }
    }

    public final class DocNumericFieldBuilder
    extends BaseNumericFieldBuilder<DocNumericFieldBuilder>
    implements NumericFieldAdder<B> {
        private DocNumericFieldBuilder(String name) {
            super(name);
        }

        private DocNumericFieldBuilder(NumericSchemaItem<?> item) {
            super(item);
        }

        @Override
        public B add(int value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }

        @Override
        public B add(long value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }

        @Override
        public B add(float value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }

        @Override
        public B add(double value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }
    }
}

