/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.document;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.derquinse.common.reflect.This;
import org.apache.lucene.document.Field;

public abstract class FieldableBuilder<B extends FieldableBuilder<B>>
extends This<B> {
    private final String name;
    private boolean store = false;

    FieldableBuilder(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"The field name must be provided");
    }

    final String name() {
        return this.name;
    }

    final Field.Store fieldStore() {
        return this.store ? Field.Store.YES : Field.Store.NO;
    }

    public final B store(boolean store) {
        this.store = store;
        return (B)((Object)((FieldableBuilder)this.thisValue()));
    }

    public final B store() {
        return this.store(true);
    }

    public final B store(@Nullable Field.Store store) {
        return this.store(Field.Store.YES == store);
    }

    final Field.Store checkUsed(boolean index) {
        Preconditions.checkState((index || this.store ? 1 : 0) != 0, (Object)"Field neither stored nor indexed");
        return this.fieldStore();
    }
}

