/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.document;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Reader;
import javax.annotation.Nullable;
import net.conquiris.lucene.document.FieldableBuilder;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;

public abstract class BaseFieldBuilder<B extends BaseFieldBuilder<B>>
extends FieldableBuilder<B> {
    private boolean index = true;
    private boolean tokenize = true;
    private boolean norms = true;
    private Field.TermVector vector = Field.TermVector.NO;

    BaseFieldBuilder(String name) {
        super(name);
    }

    private Field.Index fieldIndex() {
        if (this.index) {
            if (this.tokenize) {
                return this.norms ? Field.Index.ANALYZED : Field.Index.ANALYZED_NO_NORMS;
            }
            return this.norms ? Field.Index.NOT_ANALYZED : Field.Index.NOT_ANALYZED_NO_NORMS;
        }
        return Field.Index.NO;
    }

    public final B index(boolean index) {
        this.index = index;
        return (B)((Object)((BaseFieldBuilder)this.thisValue()));
    }

    public final B index(@Nullable Field.Index index) {
        if (index == Field.Index.ANALYZED) {
            this.index = true;
            this.tokenize = true;
            this.norms = true;
        } else if (index == Field.Index.ANALYZED_NO_NORMS) {
            this.index = true;
            this.tokenize = true;
            this.norms = false;
        } else if (index == Field.Index.NOT_ANALYZED) {
            this.index = true;
            this.tokenize = false;
            this.norms = true;
        } else if (index == Field.Index.NOT_ANALYZED_NO_NORMS) {
            this.index = true;
            this.tokenize = false;
            this.norms = false;
        } else {
            this.index = false;
        }
        return (B)((Object)((BaseFieldBuilder)this.thisValue()));
    }

    public final B tokenize(boolean tokenize) {
        this.tokenize = tokenize;
        return (B)((Object)((BaseFieldBuilder)this.thisValue()));
    }

    public final B norms(boolean norms) {
        this.norms = norms;
        return (B)((Object)((BaseFieldBuilder)this.thisValue()));
    }

    public final B vector(@Nullable Field.TermVector vector) {
        this.vector = (Field.TermVector)Objects.firstNonNull((Object)vector, (Object)Field.TermVector.NO);
        return (B)((Object)((BaseFieldBuilder)this.thisValue()));
    }

    public final Field build(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"The field value must be provided");
        return new Field(this.name(), value, this.checkUsed(this.index), this.fieldIndex(), this.vector);
    }

    private Field decorateIndexed(Field field) {
        if (!this.norms) {
            field.setOmitNorms(true);
        }
        return field;
    }

    public final Field build(Reader reader) {
        Preconditions.checkNotNull((Object)reader, (Object)"The field value reader must be provided");
        return this.decorateIndexed(new Field(this.name(), reader, this.vector));
    }

    public final Field build(TokenStream tokenStream) {
        Preconditions.checkNotNull((Object)tokenStream, (Object)"The field value token stream must be provided");
        return this.decorateIndexed(new Field(this.name(), tokenStream, this.vector));
    }
}

