/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.lucene.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.io.Reader;
import net.conquiris.lucene.document.BaseFieldBuilder;
import net.conquiris.lucene.document.BaseNumericFieldBuilder;
import net.conquiris.lucene.document.FieldAdder;
import net.conquiris.lucene.document.NumericFieldAdder;
import net.derquinse.common.base.Builder;
import net.derquinse.common.reflect.This;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;

public abstract class BaseDocumentBuilder<B extends BaseDocumentBuilder<B>>
extends This<B>
implements Builder<Document> {
    private Document document = new Document();
    private final Multiset<String> fields = HashMultiset.create();

    protected BaseDocumentBuilder() {
    }

    private void checkAvailable() {
        Preconditions.checkState((this.document != null ? 1 : 0) != 0, (Object)"Document already built");
    }

    protected void complete(Multiset<String> fields) {
    }

    public final Document build() {
        this.checkAvailable();
        this.complete((Multiset<String>)Multisets.unmodifiableMultiset(this.fields));
        Document d = this.document;
        this.document = null;
        return d;
    }

    public final B add(Fieldable fieldable) {
        this.checkAvailable();
        Preconditions.checkNotNull((Object)fieldable, (Object)"The fieldable to add must be provided");
        this.fields.add((Object)fieldable.name());
        this.document.add(fieldable);
        return (B)((Object)((BaseDocumentBuilder)this.thisValue()));
    }

    public final B add(Iterable<? extends Fieldable> fieldables) {
        this.checkAvailable();
        Preconditions.checkNotNull(fieldables, (Object)"The fieldables to add must be provided");
        for (Fieldable fieldable : fieldables) {
            this.add(fieldable);
        }
        return (B)((Object)((BaseDocumentBuilder)this.thisValue()));
    }

    public final DocNumericFieldBuilder numeric(String name) {
        return new DocNumericFieldBuilder(name);
    }

    public final DocFieldBuilder field(String name) {
        return new DocFieldBuilder(name);
    }

    public final class DocFieldBuilder
    extends BaseFieldBuilder<DocFieldBuilder>
    implements FieldAdder<B> {
        private DocFieldBuilder(String name) {
            super(name);
        }

        @Override
        public B add(String value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }

        @Override
        public B add(Reader reader) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(reader));
        }

        @Override
        public B add(TokenStream tokenStream) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(tokenStream));
        }
    }

    public final class DocNumericFieldBuilder
    extends BaseNumericFieldBuilder<DocNumericFieldBuilder>
    implements NumericFieldAdder<B> {
        private DocNumericFieldBuilder(String name) {
            super(name);
        }

        @Override
        public B add(int value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }

        @Override
        public B add(long value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }

        @Override
        public B add(float value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }

        @Override
        public B add(double value) {
            return BaseDocumentBuilder.this.add((Fieldable)this.build(value));
        }
    }
}

