/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import net.conquiris.api.search.ReaderSupplier;
import net.conquiris.api.search.Searcher;
import net.conquiris.api.search.SearcherService;
import net.conquiris.search.AbstractSearcher;
import net.conquiris.search.Searchers;
import org.apache.lucene.search.IndexSearcher;

final class DefaultSearcherService
extends AbstractSearcher
implements SearcherService {
    private final ReaderSupplier supplier;

    DefaultSearcherService(ReaderSupplier supplier) {
        this.supplier = (ReaderSupplier)Preconditions.checkNotNull((Object)supplier, (Object)"The reader supplier must be provided");
    }

    @Override
    public <T> T search(final Function<Searcher, T> query) {
        Preconditions.checkNotNull(query, (Object)"The complex query to perform must be provided");
        return this.perform(new AbstractSearcher.Op<T>(){

            @Override
            T perform(IndexSearcher searcher) throws Exception {
                return query.apply((Object)Searchers.of(searcher));
            }
        });
    }

    @Override
    IndexSearcher getIndexSearcher() {
        return new IndexSearcher(this.supplier.get().get());
    }

    @Override
    void disposeIndexSearcher(IndexSearcher searcher) {
        try {
            searcher.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            searcher.getIndexReader().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

