/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.conquiris.api.search.ManagedReaderSupplier;
import net.conquiris.api.search.Reader;
import net.conquiris.api.search.ReaderSupplier;
import net.conquiris.search.AbstractReaderSupplier;
import org.apache.lucene.index.IndexReader;

final class DefaultManagedReaderSupplier
extends AbstractReaderSupplier
implements ManagedReaderSupplier {
    private final ReaderSupplier source;
    private final long holdTime;
    private final Stopwatch watch;
    private volatile Reader reader;
    private final AtomicLong reused = new AtomicLong();
    private final AtomicLong reopened = new AtomicLong();

    DefaultManagedReaderSupplier(ReaderSupplier source, long holdTime) {
        this.source = (ReaderSupplier)Preconditions.checkNotNull((Object)source, (Object)"The unmanaged reader source must be provided");
        this.holdTime = Math.max(0L, holdTime);
        this.watch = this.holdTime > 0L ? new Stopwatch() : null;
    }

    @Override
    public long getReused() {
        return this.reused.get();
    }

    @Override
    public long getReopened() {
        return this.reopened.get();
    }

    @Override
    Reader doGet() throws IOException {
        Reader current;
        Reader opened;
        Reader ref;
        while ((ref = this.tryGet(opened = (current = this.reader) == null ? (Reader)Preconditions.checkNotNull((Object)this.source.get(), (Object)"The source supplier returned a null reader") : null)) == null) {
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Reader tryGet(Reader opened) throws IOException {
        boolean used = false;
        boolean ok = false;
        try {
            Reader current = this.reader;
            if (current == null) {
                if (opened == null) {
                    ok = true;
                    Reader reader = null;
                    return reader;
                }
                this.start(opened);
                used = true;
                if (this.reader == null) {
                    ok = true;
                    Reader reader = opened;
                    return reader;
                }
            } else if (this.watch == null || this.watch.elapsed(TimeUnit.MILLISECONDS) > this.holdTime) {
                IndexReader indexReader = this.reader.get();
                IndexReader reopened = IndexReader.openIfChanged((IndexReader)indexReader);
                if (reopened != null) {
                    this.start(Reader.of(reopened, true));
                    this.reopened.incrementAndGet();
                } else {
                    this.reused.incrementAndGet();
                }
            } else {
                this.reused.incrementAndGet();
            }
            this.reader.get().incRef();
            ok = true;
            Reader reader = this.reader;
            return reader;
        }
        finally {
            if (!ok) {
                this.dispose();
            }
            if (opened != null && !used) {
                this.close(opened);
            }
        }
    }

    @Override
    public synchronized void dispose() {
        if (this.reader != null) {
            this.close(this.reader);
            this.reader = null;
        }
        if (this.watch != null) {
            this.watch.reset();
        }
    }

    private void close(Reader reader) {
        if (reader == null) {
            return;
        }
        IndexReader ir = reader.get();
        if (ir == null) {
            return;
        }
        try {
            ir.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void start(Reader newReader) {
        this.dispose();
        if (newReader.isReopenable()) {
            this.reader = newReader;
            if (this.watch != null) {
                this.watch.start();
            }
        }
    }
}

