/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.conquiris.api.search.CountResult;
import net.conquiris.api.search.Highlight;
import net.conquiris.api.search.HitMapper;
import net.conquiris.api.search.IndexNotAvailableException;
import net.conquiris.api.search.ItemResult;
import net.conquiris.api.search.PageResult;
import net.conquiris.api.search.SearchException;
import net.conquiris.api.search.Searcher;
import net.conquiris.lucene.search.Hit;
import net.conquiris.lucene.search.ScoredTotalHitCountCollector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHitCountCollector;

abstract class AbstractSearcher
implements Searcher {
    AbstractSearcher() {
    }

    abstract IndexSearcher getIndexSearcher();

    abstract void disposeIndexSearcher(IndexSearcher var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T perform(Op<T> operation) {
        IndexSearcher searcher = this.getIndexSearcher();
        try {
            T t = operation.apply(searcher);
            return t;
        }
        finally {
            this.disposeIndexSearcher(searcher);
        }
    }

    @Override
    public final Document doc(final int i) {
        return this.perform(new Op<Document>(){

            @Override
            Document perform(IndexSearcher searcher) throws Exception {
                return searcher.doc(i);
            }
        });
    }

    @Override
    public final Query rewrite(final Query query) {
        return this.perform(new Op<Query>(){

            @Override
            Query perform(IndexSearcher searcher) throws Exception {
                return searcher.rewrite(query);
            }
        });
    }

    @Override
    public final void search(final Query query, final Filter filter, final Collector results) {
        this.perform(new Op<Object>(){

            @Override
            Object perform(IndexSearcher searcher) throws Exception {
                searcher.search(query, filter, results);
                return null;
            }
        });
    }

    @Override
    public final TopDocs search(final Query query, final Filter filter, final int n) {
        return this.perform(new Op<TopDocs>(){

            @Override
            TopDocs perform(IndexSearcher searcher) throws Exception {
                return searcher.search(query, filter, n);
            }
        });
    }

    @Override
    public final TopFieldDocs search(final Query query, final Filter filter, final int n, final Sort sort) {
        return this.perform(new Op<TopFieldDocs>(){

            @Override
            TopFieldDocs perform(IndexSearcher searcher) throws Exception {
                return searcher.search(query, filter, n, sort);
            }
        });
    }

    private TopDocs getTopDocs(IndexSearcher searcher, Query query, Filter filter, Sort sort, int hits) throws IOException {
        Object docs = sort == null ? searcher.search(query, filter, hits) : searcher.search(query, filter, hits, sort);
        return docs;
    }

    @Override
    public final <T> ItemResult<T> getFirst(final HitMapper<T> mapper, final Query query, final @Nullable Filter filter, final @Nullable Sort sort, final @Nullable Highlight highlight) {
        return (ItemResult)this.perform(new Op<ItemResult<T>>(){

            @Override
            public ItemResult<T> perform(IndexSearcher searcher) throws Exception {
                Stopwatch w = new Stopwatch().start();
                Query rewritten = searcher.rewrite(query);
                TopDocs docs = AbstractSearcher.this.getTopDocs(searcher, query, filter, sort, 1);
                if (docs.totalHits > 0) {
                    ScoreDoc sd = docs.scoreDocs[0];
                    Highlight.HighlightedQuery highlighted = ((Highlight)Objects.firstNonNull((Object)highlight, (Object)Highlight.no())).highlight(rewritten);
                    float score = sd.score;
                    Object item = this.map(searcher, sd, highlighted, mapper);
                    return ItemResult.found((int)docs.totalHits, (float)score, (long)w.elapsed(TimeUnit.MILLISECONDS), item);
                }
                return ItemResult.notFound((long)w.elapsed(TimeUnit.MILLISECONDS));
            }
        });
    }

    @Override
    public final <T> PageResult<T> getPage(final HitMapper<T> mapper, final Query query, final int firstRecord, final int maxRecords, final @Nullable Filter filter, final @Nullable Sort sort, final @Nullable Highlight highlight) {
        if (maxRecords < 1) {
            CountResult r = this.getCount(query, filter, true);
            return PageResult.notFound((int)r.getTotalHits(), (float)r.getMaxScore(), (long)r.getTime(), (int)firstRecord);
        }
        return (PageResult)this.perform(new Op<PageResult<T>>(){

            @Override
            public PageResult<T> perform(IndexSearcher searcher) throws Exception {
                Stopwatch w = new Stopwatch().start();
                int total = firstRecord + maxRecords;
                Query rewritten = searcher.rewrite(query);
                TopDocs docs = AbstractSearcher.this.getTopDocs(searcher, rewritten, filter, sort, total);
                if (docs.totalHits > 0) {
                    int n = Math.min(total, docs.scoreDocs.length);
                    float score = docs.getMaxScore();
                    if (n > firstRecord) {
                        ArrayList items = Lists.newArrayListWithCapacity((int)(n - firstRecord));
                        Highlight.HighlightedQuery highlighted = ((Highlight)Objects.firstNonNull((Object)highlight, (Object)Highlight.no())).highlight(rewritten);
                        for (int i = firstRecord; i < n; ++i) {
                            ScoreDoc sd = docs.scoreDocs[i];
                            Object item = this.map(searcher, sd, highlighted, mapper);
                            items.add(item);
                        }
                        return PageResult.found((int)docs.totalHits, (float)score, (long)w.elapsed(TimeUnit.MILLISECONDS), (int)firstRecord, (List)items);
                    }
                    return PageResult.notFound((int)docs.totalHits, (float)score, (long)w.elapsed(TimeUnit.MILLISECONDS), (int)firstRecord);
                }
                return PageResult.notFound((long)w.elapsed(TimeUnit.MILLISECONDS), (int)firstRecord);
            }
        });
    }

    @Override
    public CountResult getCount(final Query query, final @Nullable Filter filter, final boolean score) {
        return this.perform(new Op<CountResult>(){

            @Override
            public CountResult perform(IndexSearcher searcher) throws Exception {
                ScoredTotalHitCountCollector collector;
                ScoredTotalHitCountCollector scoredCollector;
                Stopwatch w = new Stopwatch().start();
                if (score) {
                    collector = scoredCollector = new ScoredTotalHitCountCollector();
                } else {
                    scoredCollector = null;
                    collector = new TotalHitCountCollector();
                }
                searcher.search(query, filter, (Collector)collector);
                float maxScore = score ? scoredCollector.getMaxScore() : 1.0f;
                return CountResult.of((int)collector.getTotalHits(), (float)maxScore, (long)w.elapsed(TimeUnit.MILLISECONDS));
            }
        });
    }

    abstract class Op<T>
    implements Function<IndexSearcher, T> {
        Op() {
        }

        public final T apply(IndexSearcher searcher) {
            try {
                return this.perform(searcher);
            }
            catch (SearchException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IndexNotAvailableException((Throwable)e);
            }
        }

        final <H> H map(IndexSearcher searcher, ScoreDoc sd, Highlight.HighlightedQuery q, HitMapper<H> mapper) throws Exception {
            int id = sd.doc;
            float score = sd.score;
            FieldSelector selector = mapper.getFieldSelector();
            Document doc = selector == null ? searcher.doc(id) : searcher.doc(id, selector);
            Hit hit = Hit.of((int)id, (float)score, (Document)doc, q.getFragments(doc));
            return (H)mapper.apply(hit);
        }

        abstract T perform(IndexSearcher var1) throws Exception;
    }
}

