/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import net.conquiris.api.index.IndexInfo;
import net.conquiris.api.index.IndexStatus;
import net.conquiris.api.index.Indexer;
import net.conquiris.api.index.WriterResult;
import net.conquiris.index.AbstractLocalIndexerService;
import net.conquiris.index.DefaultWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;

public final class DirectoryIndexerService
extends AbstractLocalIndexerService {
    private final Indexer indexer;
    private final Directory directory;
    private final Supplier<IndexWriterConfig> configSupplier;
    private volatile IndexStatus indexStatus = IndexStatus.OK;
    private final Lock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    private volatile Session session;

    public DirectoryIndexerService(Indexer indexer, Directory directory, Supplier<IndexWriterConfig> configSupplier) {
        this.indexer = (Indexer)Preconditions.checkNotNull((Object)indexer, (Object)"The indexer to use must be provided");
        this.directory = (Directory)Preconditions.checkNotNull((Object)directory, (Object)"The directory to use must be provided");
        this.configSupplier = (Supplier)Preconditions.checkNotNull(configSupplier, (Object)"The index writer configuration supplier must be provided");
    }

    public IndexInfo getIndexInfo() {
        return (IndexInfo)new GetIndexInfo().get();
    }

    public IndexStatus getIndexStatus() {
        return this.indexStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lock.lock();
        try {
            if (this.session != null) {
                return;
            }
            this.session = new Session();
            new Task(this.session, 0L);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            Session s = this.session;
            if (s == null) {
                return;
            }
            this.session = null;
            s.shutdown();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckpoint(String checkpoint) {
        this.lock.lock();
        try {
            Session s = this.session;
            if (s == null) {
                return;
            }
            new Task(s, checkpoint);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex() {
        this.lock.lock();
        try {
            Session s = this.session;
            if (s == null) {
                return;
            }
            new Task(s);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isIndexStarted() {
        return this.session != null;
    }

    private final class Task
    implements Runnable {
        private final Session session;
        private final boolean scheduled;
        private final boolean overrideCheckpoint;
        private final String checkpoint;
        private final boolean create;

        private Task(Session session, boolean scheduled, long delay, boolean overrideCheckpoint, String checkpoint, boolean create) {
            this.session = (Session)Preconditions.checkNotNull((Object)session);
            this.scheduled = scheduled;
            this.overrideCheckpoint = overrideCheckpoint;
            this.checkpoint = checkpoint;
            this.create = create;
            session.schelude(this, delay);
        }

        Task(Session session, long delay) {
            this(session, true, delay, false, null, false);
        }

        Task(@Nullable Session session, String checkpoint) {
            this(session, false, 0L, true, checkpoint, false);
        }

        Task(Session session) {
            this(session, false, 0L, false, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            boolean ok = false;
            WriterResult result = WriterResult.ERROR;
            IndexWriter indexWriter = this.session.getOpenWriter(this.create);
            try {
                DefaultWriter writer = new DefaultWriter(DirectoryIndexerService.this.writerLog(), indexWriter, this.overrideCheckpoint, this.checkpoint, this.create);
                try {
                    DirectoryIndexerService.this.indexer.index(writer);
                    result = writer.done();
                    ok = true;
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    DirectoryIndexerService.this.log().error((Throwable)e, "Uncaught exception", new Object[0]);
                }
            }
            finally {
                if (!ok) {
                    this.session.closeWriter();
                }
                if (this.scheduled) {
                    long delay;
                    switch (result) {
                        case NORMAL: {
                            delay = DirectoryIndexerService.this.getDelays().getNormal();
                            break;
                        }
                        case IDLE: {
                            delay = DirectoryIndexerService.this.getDelays().getIdle();
                            break;
                        }
                        default: {
                            delay = DirectoryIndexerService.this.getDelays().getError();
                        }
                    }
                    new Task(this.session, delay);
                }
            }
        }
    }

    private final class Session {
        private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        @GuardedBy(value="lock")
        private IndexWriter indexWriter = null;
        @GuardedBy(value="lock")
        private boolean active = true;

        private Session() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IndexWriter getOpenWriter(boolean create) {
            DirectoryIndexerService.this.lock.lock();
            try {
                if (!this.active) {
                    IndexWriter indexWriter = null;
                    return indexWriter;
                }
                if (create && this.indexWriter != null) {
                    this.closeWriter();
                }
                if (this.indexWriter == null) {
                    this.indexWriter = (IndexWriter)new OpenWriter(create).get();
                }
                IndexWriter indexWriter = this.indexWriter;
                return indexWriter;
            }
            finally {
                DirectoryIndexerService.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeWriter() {
            DirectoryIndexerService.this.lock.lock();
            boolean nullify = false;
            try {
                if (this.indexWriter != null) {
                    Closeables.close((Closeable)this.indexWriter, (boolean)false);
                    nullify = true;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (nullify) {
                    this.indexWriter = null;
                }
                DirectoryIndexerService.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            DirectoryIndexerService.this.lock.lock();
            try {
                this.active = false;
                this.executor.shutdownNow();
                this.closeWriter();
            }
            finally {
                DirectoryIndexerService.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schelude(Task task, long delay) {
            DirectoryIndexerService.this.lock.lock();
            try {
                if (this.active) {
                    this.executor.schedule(task, delay, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                DirectoryIndexerService.this.lock.unlock();
            }
        }
    }

    private final class OpenWriter
    extends Wrapped<IndexWriter> {
        private final boolean create;

        OpenWriter(boolean create) {
            super("Unable to open index writer", null);
            this.create = create;
        }

        @Override
        IndexWriter run() throws IOException {
            IndexWriterConfig config = (IndexWriterConfig)Preconditions.checkNotNull((Object)DirectoryIndexerService.this.configSupplier.get(), (Object)"Null writer config supplied");
            config.setOpenMode(this.create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            return new IndexWriter(DirectoryIndexerService.this.directory, config);
        }
    }

    private final class GetIndexInfo
    extends Wrapped<IndexInfo> {
        GetIndexInfo() {
            super("Unable to get index info", IndexInfo.empty());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        IndexInfo run() throws IOException {
            if (!IndexReader.indexExists((Directory)DirectoryIndexerService.this.directory)) {
                return IndexInfo.empty();
            }
            IndexReader reader = IndexReader.open((Directory)DirectoryIndexerService.this.directory);
            boolean threw = true;
            try {
                IndexInfo info = IndexInfo.fromMap((int)reader.numDocs(), (Map)reader.getIndexCommit().getUserData());
                threw = false;
                IndexInfo indexInfo = info;
                return indexInfo;
            }
            finally {
                Closeables.close((Closeable)reader, (boolean)threw);
            }
        }
    }

    private abstract class Wrapped<T> {
        private String message;
        private T fallback;

        Wrapped(String message, T fallback) {
            this.message = (String)Preconditions.checkNotNull((Object)message);
            this.fallback = fallback;
        }

        private void error(Exception e, IndexStatus status) {
            DirectoryIndexerService.this.log().error((Throwable)e, this.message, new Object[0]);
            if (status != null) {
                DirectoryIndexerService.this.indexStatus = status;
            }
        }

        final T get() {
            try {
                return this.run();
            }
            catch (LockObtainFailedException e) {
                this.error((Exception)((Object)e), IndexStatus.LOCKED);
            }
            catch (CorruptIndexException e) {
                this.error((Exception)((Object)e), IndexStatus.CORRUPT);
            }
            catch (IOException e) {
                this.error(e, IndexStatus.IOERROR);
            }
            catch (RuntimeException e) {
                this.error(e, IndexStatus.ERROR);
            }
            return this.fallback;
        }

        abstract T run() throws IOException;
    }
}

