/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import com.google.common.base.Preconditions;
import java.io.IOException;
import net.conquiris.api.search.Reader;
import net.conquiris.search.AbstractReaderSupplier;
import net.conquiris.search.ReaderSuppliers;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;

final class DirectoryReaderSupplier
extends AbstractReaderSupplier {
    private final Directory directory;

    DirectoryReaderSupplier(Directory directory) {
        this.directory = (Directory)Preconditions.checkNotNull((Object)directory, (Object)"The index directory must be provided");
    }

    @Override
    Reader doGet() throws IOException {
        try {
            IndexReader reader = IndexReader.open((Directory)this.directory);
            return Reader.of(reader, true);
        }
        catch (IndexNotFoundException e) {
            return ReaderSuppliers.empty().get();
        }
    }
}

