/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.index;

import com.google.common.base.Preconditions;
import net.conquiris.api.index.DocumentWriter;
import net.conquiris.api.index.IndexException;
import net.conquiris.api.index.Writer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;

final class DefaultDocumentWriter
implements DocumentWriter {
    private final Writer writer;

    DefaultDocumentWriter(Writer writer) {
        this.writer = (Writer)Preconditions.checkNotNull((Object)writer, (Object)"The writer must be provided");
    }

    @Override
    public void cancel() throws InterruptedException {
        this.writer.cancel();
    }

    @Override
    public DocumentWriter add(Document document) throws InterruptedException, IndexException {
        this.writer.add(document);
        return this;
    }

    @Override
    public DocumentWriter add(Document document, Analyzer analyzer) throws InterruptedException, IndexException {
        this.writer.add(document, analyzer);
        return this;
    }

    @Override
    public DocumentWriter deleteAll() throws InterruptedException, IndexException {
        this.writer.deleteAll();
        return this;
    }

    @Override
    public DocumentWriter delete(String field, String text) throws InterruptedException, IndexException {
        this.writer.delete(field, text);
        return this;
    }

    @Override
    public DocumentWriter delete(Term term) throws InterruptedException, IndexException {
        this.writer.delete(term);
        return this;
    }

    @Override
    public DocumentWriter update(String field, String text, Document document) throws InterruptedException, IndexException {
        this.writer.update(field, text, document);
        return this;
    }

    @Override
    public DocumentWriter update(Term term, Document document) throws InterruptedException, IndexException {
        this.writer.update(term, document);
        return this;
    }

    @Override
    public DocumentWriter update(String field, String text, Document document, Analyzer analyzer) throws InterruptedException, IndexException {
        this.writer.update(field, text, document, analyzer);
        return this;
    }

    @Override
    public DocumentWriter update(Term term, Document document, Analyzer analyzer) throws InterruptedException, IndexException {
        this.writer.update(term, document, analyzer);
        return this;
    }
}

