/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.index;

import net.conquiris.index.AbstractDirectoryIndexerServiceTest;
import net.conquiris.support.TestIndexer;
import net.conquiris.support.TestSimpleIndexer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectoryIndexerServiceTest
extends AbstractDirectoryIndexerServiceTest {
    private static final int CP1 = 1000000;
    private static final int CP2 = 10000000;
    private final TestIndexer indexer = new TestSimpleIndexer();

    private void create(int target) {
        this.indexer.setTarget(target);
        this.create(this.indexer);
        this.service.start();
    }

    @Test
    public void worker() throws InterruptedException {
        this.create(0x7FFFFFF5);
        Assert.assertTrue((this.checkpoint() >= 0 ? 1 : 0) != 0);
        Thread.sleep(100L);
        int cp1 = this.checkpoint();
        Thread.sleep(500L);
        int cp2 = this.checkpoint();
        Assert.assertTrue((cp2 > cp1 ? 1 : 0) != 0);
        this.service.stop();
        int cp3 = this.checkpoint();
        Assert.assertTrue((cp3 >= cp2 ? 1 : 0) != 0);
        Thread.sleep(500L);
        Assert.assertTrue((this.checkpoint() == cp3 ? 1 : 0) != 0);
        this.service.setCheckpoint(Integer.toString(1000000));
        Thread.sleep(100L);
        Assert.assertTrue((this.checkpoint() == cp3 ? 1 : 0) != 0);
        this.service.reindex();
        Thread.sleep(100L);
        Assert.assertTrue((this.checkpoint() == cp3 ? 1 : 0) != 0);
        this.service.start();
        this.service.setCheckpoint(Integer.toString(1000000));
        Thread.sleep(500L);
        Assert.assertTrue((this.checkpoint() > 1000000 ? 1 : 0) != 0);
        this.service.reindex();
        Thread.sleep(100L);
        Assert.assertTrue((this.checkpoint() < 1000000 ? 1 : 0) != 0);
        this.service.setCheckpoint(Integer.toString(10000000));
        Thread.sleep(500L);
        Assert.assertTrue((this.checkpoint() > 10000000 ? 1 : 0) != 0);
        this.service.setCheckpoint(null);
        Thread.sleep(500L);
        Assert.assertTrue((this.checkpoint() < 1000000 ? 1 : 0) != 0);
        this.service.stop();
    }

    private void checkEmpty() throws InterruptedException {
        Thread.sleep(200L);
        Assert.assertTrue((this.checkpoint() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void empty() throws InterruptedException {
        this.create(0);
        this.checkEmpty();
        this.service.stop();
        this.checkEmpty();
        this.service.setCheckpoint(Integer.toString(1000000));
        this.checkEmpty();
        this.service.reindex();
        this.checkEmpty();
        this.service.start();
        this.checkEmpty();
        this.service.setCheckpoint(Integer.toString(1000000));
        this.checkEmpty();
        this.service.reindex();
        this.checkEmpty();
        this.service.setCheckpoint(Integer.toString(10000000));
        this.checkEmpty();
        this.service.setCheckpoint(null);
        this.checkEmpty();
    }
}

