/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import java.io.IOException;
import java.lang.ref.WeakReference;
import net.conquiris.api.search.IndexNotAvailableException;
import net.conquiris.api.search.Reader;
import net.conquiris.lucene.Conquiris;
import net.conquiris.search.AbstractReaderSupplier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

final class EmptyIndex
extends AbstractReaderSupplier {
    private static volatile WeakReference<EmptyIndex> instance;
    private final Directory directory = new RAMDirectory();

    static EmptyIndex getInstance() {
        try {
            EmptyIndex i;
            WeakReference<EmptyIndex> r = instance;
            if (r != null && (i = (EmptyIndex)r.get()) != null) {
                return i;
            }
            return EmptyIndex.create();
        }
        catch (IOException e) {
            throw new IndexNotAvailableException((Throwable)e);
        }
    }

    static Directory newDirectory() {
        try {
            return new EmptyIndex().directory;
        }
        catch (IOException e) {
            throw new IndexNotAvailableException((Throwable)e);
        }
    }

    private static synchronized EmptyIndex create() throws IOException {
        EmptyIndex i;
        if (instance != null && (i = (EmptyIndex)instance.get()) != null) {
            return i;
        }
        i = new EmptyIndex();
        instance = new WeakReference<EmptyIndex>(i);
        return i;
    }

    private EmptyIndex() throws IOException {
        IndexWriter w = new IndexWriter(this.directory, Conquiris.writerConfig());
        w.close();
    }

    @Override
    Reader doGet() throws IOException {
        return Reader.of(IndexReader.open((Directory)EmptyIndex.getInstance().directory), false);
    }
}

