/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.support;

import com.beust.jcommander.internal.Lists;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.conquiris.api.index.DocumentWriter;
import net.conquiris.api.index.IndexException;
import net.conquiris.api.index.Subindexer;
import net.conquiris.api.index.Writer;
import net.conquiris.support.TestIndexer;
import net.conquiris.support.TestSupport;

public final class TestMultiIndexer
extends TestIndexer {
    private int target = 5000;
    private final ExecutorService executor = Executors.newFixedThreadPool(10);
    private final SecureRandom random = new SecureRandom();

    @Override
    int index(int cp, Writer writer) throws InterruptedException, IndexException {
        int start = cp + 1;
        int end = Math.min(this.target, start + 19);
        List list = Lists.newArrayList();
        for (int i = start; i <= end; ++i) {
            list.add(new Sub(i));
        }
        writer.runSubindexers((Executor)this.executor, (Iterable)list);
        return end;
    }

    @Override
    public int getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(int target) {
        this.target = target;
    }

    final class Sub
    implements Subindexer {
        private final int id;

        Sub(int id) {
            this.id = id;
        }

        public void index(DocumentWriter writer) throws InterruptedException, IndexException {
            Thread.sleep(1 + TestMultiIndexer.this.random.nextInt(15));
            writer.add(TestSupport.document(this.id));
        }
    }
}

