/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import com.google.common.base.Function;
import net.conquiris.api.search.ReaderSupplier;
import net.conquiris.api.search.Searcher;
import net.conquiris.api.search.SearcherService;
import net.conquiris.lucene.index.Terms;
import net.conquiris.lucene.search.Filters;
import net.conquiris.schema.IntegerSchemaItem;
import net.conquiris.search.ReaderSuppliers;
import net.conquiris.search.Searchers;
import net.conquiris.support.TestSupport;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.TermsFilter;
import org.apache.lucene.store.Directory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleSearcherTest {
    @Test
    public void test() throws Exception {
        Directory d = TestSupport.createRAMDirectory(1, 10);
        SearcherService s = Searchers.service((ReaderSupplier)ReaderSuppliers.managed((Directory)d));
        Assert.assertEquals((int)TestSupport.getCount((Searcher)s), (int)10);
        TestSupport.write(d, 11, 15);
        Assert.assertEquals((int)TestSupport.getCount((Searcher)s), (int)15);
        TestSupport.found((Searcher)s, 2);
        TestSupport.found((Searcher)s, 6);
        TermsFilter f1 = Filters.terms((Function)Terms.termBuilder((IntegerSchemaItem)TestSupport.ID), (Object[])new Integer[]{2, 3, 4});
        TestSupport.found((Searcher)s, 2, (Filter)f1);
        TestSupport.notFound((Searcher)s, 6, (Filter)f1);
        Assert.assertEquals((int)TestSupport.getCount((Searcher)s, (Filter)f1), (int)3);
        Filter f2 = Filters.negate((Filter)f1);
        TestSupport.notFound((Searcher)s, 2, f2);
        TestSupport.found((Searcher)s, 6, f2);
        Assert.assertEquals((int)TestSupport.getCount((Searcher)s, f2), (int)12);
        BooleanFilter f3 = new BooleanFilter();
        f3.add((Filter)f1, BooleanClause.Occur.MUST);
        f3.add(f2, BooleanClause.Occur.MUST);
        Assert.assertEquals((int)TestSupport.getCount((Searcher)s, (Filter)f3), (int)0);
    }
}

