/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.index;

import net.conquiris.index.AbstractDirectoryIndexerServiceTest;
import net.conquiris.support.TestIndexer;
import net.conquiris.support.TestMultiIndexer;
import net.conquiris.support.TestSimpleIndexer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectoryIndexerServiceSMTest
extends AbstractDirectoryIndexerServiceTest {
    private TestIndexer indexer;

    private void check() {
        int cp = this.checkpoint();
        if (cp > 0) {
            this.found(cp - 3);
            this.notFound(cp + 100000);
            Assert.assertTrue((this.count() >= cp ? 1 : 0) != 0);
        }
    }

    private void create() {
        this.create(this.indexer);
    }

    private void testService() throws InterruptedException {
        this.create();
        this.check();
        this.service.start();
        this.doTest();
        this.service.stop();
        this.indexer.setTarget(2 * this.indexer.getTarget());
        this.service.start();
        this.doTest();
        this.service.stop();
        System.out.println("Count: " + this.count());
    }

    private void doTest() throws InterruptedException {
        for (int i = 0; i < 50; ++i) {
            Thread.sleep(20L);
            this.check();
        }
        Assert.assertTrue((this.checkpoint() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.count() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void simple() throws InterruptedException {
        this.indexer = new TestSimpleIndexer();
        this.testService();
    }

    @Test(dependsOnMethods={"simple"})
    public void multi() throws InterruptedException {
        this.indexer = new TestMultiIndexer();
        this.indexer.setTarget(20000);
        this.testService();
    }
}

