/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.Atomics;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import net.conquiris.api.index.DocumentWriter;
import net.conquiris.api.index.IndexException;
import net.conquiris.api.index.IndexInfo;
import net.conquiris.api.index.IndexStatus;
import net.conquiris.api.index.Subindexer;
import net.conquiris.api.index.Writer;
import net.conquiris.api.index.WriterResult;
import net.conquiris.index.AbstractWriter;
import net.conquiris.index.DefaultDocumentWriter;
import net.derquinse.common.log.ContextLog;
import net.derquinse.common.util.concurrent.Interruptions;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.ThreadInterruptedException;

final class DefaultWriter
extends AbstractWriter {
    private final ContextLog log;
    private final Lock lock = new ReentrantLock();
    private final ReadWriteLock indexLock = new ReentrantReadWriteLock();
    private final IndexWriter writer;
    private final IndexInfo indexInfo;
    @GuardedBy(value="lock")
    private final Map<String, String> properties;
    private final Set<String> keys;
    private volatile boolean interrupted = false;
    @GuardedBy(value="lock")
    private volatile WriterResult result = null;
    @GuardedBy(value="lock")
    private volatile boolean cancelled = false;
    @GuardedBy(value="indexLock")
    private boolean updated = false;
    @GuardedBy(value="indexLock")
    private final AtomicReference<IndexStatus> indexStatus = Atomics.newReference((Object)IndexStatus.OK);
    @GuardedBy(value="lock")
    private volatile String checkpoint;
    @GuardedBy(value="lock")
    private volatile String targetCheckpoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultWriter(ContextLog log, IndexWriter writer, boolean overrideCheckpoint, @Nullable String checkpoint, boolean created) throws IndexException {
        this.log = (ContextLog)Preconditions.checkNotNull((Object)log, (Object)"The log context must be provided");
        this.writer = (IndexWriter)Preconditions.checkNotNull((Object)writer, (Object)"The index writer must be provided");
        this.properties = new MapMaker().makeMap();
        this.keys = Collections.unmodifiableSet(this.properties.keySet());
        try {
            int documents;
            Object commitData;
            if (created) {
                commitData = ImmutableMap.of();
                documents = 0;
            } else {
                IndexReader reader = IndexReader.open((IndexWriter)writer, (boolean)false);
                try {
                    Map data = reader.getCommitUserData();
                    if (overrideCheckpoint) {
                        HashMap modified = Maps.newHashMap();
                        if (data != null) {
                            modified.putAll(data);
                        }
                        modified.put("cq:checkpoint", checkpoint);
                        commitData = modified;
                    } else {
                        commitData = data;
                    }
                    documents = reader.numDocs();
                }
                finally {
                    Closeables.closeQuietly((Closeable)reader);
                }
            }
            this.indexInfo = IndexInfo.fromMap((int)documents, (Map)commitData);
            this.checkpoint = this.indexInfo.getCheckpoint();
            this.targetCheckpoint = this.indexInfo.getTargetCheckpoint();
            this.properties.putAll((Map<String, String>)this.indexInfo.getProperties());
        }
        catch (LockObtainFailedException e) {
            this.indexStatus.compareAndSet(IndexStatus.OK, IndexStatus.LOCKED);
            throw new IndexException((Throwable)e);
        }
        catch (CorruptIndexException e) {
            this.indexStatus.compareAndSet(IndexStatus.OK, IndexStatus.CORRUPT);
            throw new IndexException((Throwable)e);
        }
        catch (IOException e) {
            this.indexStatus.compareAndSet(IndexStatus.OK, IndexStatus.IOERROR);
            throw new IndexException((Throwable)e);
        }
        catch (RuntimeException e) {
            this.indexStatus.compareAndSet(IndexStatus.OK, IndexStatus.ERROR);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    WriterResult done() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    IndexStatus getIndexStatus() {
        return this.indexStatus.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean ensureAvailable() throws InterruptedException {
        Preconditions.checkState((this.result == null ? 1 : 0) != 0, (Object)"The writer can't be used any longer");
        if (this.interrupted) {
            throw new InterruptedException();
        }
        boolean ok = false;
        try {
            Interruptions.throwIfInterrupted();
            ok = true;
        }
        finally {
            if (!ok) {
                this.interrupted = true;
            }
        }
        return this.canContinue();
    }

    private boolean canContinue() {
        return !this.cancelled && !this.interrupted && IndexStatus.OK == this.indexStatus.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws InterruptedException {
        this.lock.lock();
        try {
            this.ensureAvailable();
            if (!this.cancelled) {
                this.checkpoint = this.indexInfo.getCheckpoint();
                this.properties.clear();
                this.properties.putAll((Map<String, String>)this.indexInfo.getProperties());
                this.cancelled = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public IndexInfo getIndexInfo() throws InterruptedException {
        return null;
    }

    @Override
    public String getCheckpoint() throws InterruptedException {
        this.ensureAvailable();
        return this.checkpoint;
    }

    @Override
    public String getTargetCheckpoint() throws InterruptedException {
        this.ensureAvailable();
        return this.targetCheckpoint;
    }

    @Override
    public String getProperty(String key) throws InterruptedException {
        this.ensureAvailable();
        return this.properties.get(key);
    }

    @Override
    public Set<String> getPropertyKeys() throws InterruptedException {
        this.ensureAvailable();
        return this.keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setCheckpoint(String checkpoint) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.ensureAvailable()) {
                this.checkpoint = checkpoint;
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setTargetCheckpoint(String targetCheckpoint) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.ensureAvailable()) {
                this.targetCheckpoint = targetCheckpoint;
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setProperty(String key, String value) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.ensureAvailable()) {
                DefaultWriter.checkKey(key);
                if (value != null) {
                    this.properties.put(key, value);
                } else {
                    this.properties.remove(key);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setProperties(Map<String, String> values) throws InterruptedException {
        Preconditions.checkNotNull(values, (Object)"The commit properties map is null");
        this.lock.lock();
        try {
            if (this.ensureAvailable()) {
                HashMap put = Maps.newHashMapWithExpectedSize((int)values.size());
                HashSet remove = Sets.newHashSet();
                for (Map.Entry<String, String> e : values.entrySet()) {
                    String key = e.getKey();
                    String value = e.getValue();
                    DefaultWriter.checkKey(key);
                    if (value != null) {
                        put.put(key, value);
                        continue;
                    }
                    remove.add(key);
                }
                this.properties.putAll(put);
                for (String k : remove) {
                    this.properties.remove(k);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    private Analyzer analyzer(Analyzer a) {
        return a != null ? a : this.writer.getAnalyzer();
    }

    @Override
    public Writer add(final Document document, final Analyzer analyzer) throws InterruptedException {
        new IndexOp(){

            @Override
            boolean perform() throws IOException, InterruptedException {
                if (document != null) {
                    DefaultWriter.this.writer.addDocument(document, DefaultWriter.this.analyzer(analyzer));
                    return true;
                }
                return false;
            }
        }.run();
        return this;
    }

    @Override
    public Writer deleteAll() throws InterruptedException {
        new IndexOp(){

            @Override
            boolean perform() throws IOException, InterruptedException {
                DefaultWriter.this.writer.deleteDocuments((Query)new MatchAllDocsQuery());
                return true;
            }
        }.run();
        return this;
    }

    @Override
    public Writer delete(final Term term) throws InterruptedException {
        new IndexOp(){

            @Override
            boolean perform() throws IOException, InterruptedException {
                if (!AbstractWriter.isTermNull(term)) {
                    DefaultWriter.this.writer.deleteDocuments(term);
                    return true;
                }
                return false;
            }
        }.run();
        return this;
    }

    @Override
    public Writer update(final Term term, final Document document, final Analyzer analyzer) throws InterruptedException {
        new IndexOp(){

            @Override
            boolean perform() throws IOException, InterruptedException {
                if (document != null) {
                    if (AbstractWriter.isTermNull(term)) {
                        DefaultWriter.this.writer.addDocument(document, DefaultWriter.this.analyzer(analyzer));
                    } else {
                        DefaultWriter.this.writer.updateDocument(term, document, DefaultWriter.this.analyzer(analyzer));
                    }
                    return true;
                }
                return false;
            }
        }.run();
        return this;
    }

    @Override
    public Writer runSubindexers(Executor executor, Iterable<? extends Subindexer> subindexers) throws InterruptedException, IndexException {
        Preconditions.checkNotNull((Object)executor, (Object)"The executor must be provided");
        Preconditions.checkNotNull((Object)executor, (Object)"The subindexers must be provided");
        if (this.ensureAvailable()) {
            DefaultDocumentWriter subwriter = new DefaultDocumentWriter(this);
            ExecutorCompletionService<IndexStatus> ecs = new ExecutorCompletionService<IndexStatus>(executor);
            int n = 0;
            for (Subindexer subindexer : Iterables.filter(subindexers, (Predicate)Predicates.notNull())) {
                ecs.submit(new SubindexerTask(subwriter, subindexer));
                ++n;
            }
            for (int i = 0; i < n && this.ensureAvailable(); ++i) {
                ecs.take();
            }
        }
        return this;
    }

    private final class SubindexerTask
    implements Callable<IndexStatus> {
        private final DocumentWriter writer;
        private final Subindexer indexer;

        SubindexerTask(DocumentWriter writer, Subindexer indexer) {
            this.writer = (DocumentWriter)Preconditions.checkNotNull((Object)writer, (Object)"The document writer must be provided");
            this.indexer = (Subindexer)Preconditions.checkNotNull((Object)indexer, (Object)"The subindexer must be provided");
        }

        @Override
        public IndexStatus call() throws Exception {
            if (DefaultWriter.this.ensureAvailable()) {
                this.indexer.index(this.writer);
            }
            return (IndexStatus)DefaultWriter.this.indexStatus.get();
        }
    }

    private abstract class IndexOp {
        IndexOp() {
        }

        abstract boolean perform() throws IOException, InterruptedException;

        final void run() throws InterruptedException {
            DefaultWriter.this.indexLock.readLock().lock();
            boolean cancel = false;
            try {
                if (DefaultWriter.this.ensureAvailable() && this.perform()) {
                    DefaultWriter.this.updated = true;
                }
            }
            catch (ThreadInterruptedException e) {
                DefaultWriter.this.interrupted = true;
                throw new InterruptedException();
            }
            catch (LockObtainFailedException e) {
                DefaultWriter.this.indexStatus.compareAndSet(IndexStatus.OK, IndexStatus.LOCKED);
                throw new IndexException((Throwable)e);
            }
            catch (CorruptIndexException e) {
                DefaultWriter.this.indexStatus.compareAndSet(IndexStatus.OK, IndexStatus.CORRUPT);
                throw new IndexException((Throwable)e);
            }
            catch (IOException e) {
                DefaultWriter.this.indexStatus.compareAndSet(IndexStatus.OK, IndexStatus.IOERROR);
                throw new IndexException((Throwable)e);
            }
            finally {
                if (cancel) {
                    DefaultWriter.this.cancelled = true;
                }
                DefaultWriter.this.indexLock.readLock().unlock();
            }
        }
    }
}

