/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.support;

import com.google.common.base.Function;
import java.io.IOException;
import net.conquiris.api.search.AbstractHitMapper;
import net.conquiris.api.search.HitMapper;
import net.conquiris.api.search.ItemResult;
import net.conquiris.api.search.PageResult;
import net.conquiris.api.search.ReaderSupplier;
import net.conquiris.api.search.Searcher;
import net.conquiris.api.search.SearcherService;
import net.conquiris.lucene.Conquiris;
import net.conquiris.lucene.document.DocumentBuilder;
import net.conquiris.lucene.index.Terms;
import net.conquiris.lucene.search.Hit;
import net.conquiris.schema.IntegerSchemaItem;
import net.conquiris.schema.SchemaItems;
import net.conquiris.schema.TextSchemaItem;
import net.conquiris.search.ReaderSuppliers;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.testng.Assert;

public final class TestSupport {
    public static final IntegerSchemaItem ID = SchemaItems.intValue((String)"CQ-ID", (boolean)true, (boolean)true, (boolean)true);
    public static final TextSchemaItem BASE = SchemaItems.id((String)"BASE", (boolean)true, (boolean)true, (boolean)true);
    public static final TextSchemaItem ANALYZED = SchemaItems.tokenized((String)"ANALYZED", (boolean)true);
    public static final HitMapper<Node> MAPPER = new AbstractHitMapper<Node>(){

        public Node apply(Hit hit) {
            Node node = new Node();
            node.id = (Integer)hit.item(ID).get();
            node.analyzed = (String)hit.item(ANALYZED).get();
            return node;
        }
    };

    private TestSupport() {
        throw new AssertionError();
    }

    private static final String value(int value) {
        return "value_" + value;
    }

    public static Document document(int value, String base) {
        DocumentBuilder builder = DocumentBuilder.create();
        builder.add(ID, value);
        String text = TestSupport.value(value);
        builder.add(BASE, text);
        builder.add(ANALYZED, text);
        return builder.build();
    }

    public static Document document(int value) {
        return TestSupport.document(value, BASE.getName());
    }

    public static Term termId(int value) {
        return Terms.term((IntegerSchemaItem)ID, (int)value);
    }

    public static ItemResult<Node> getFirst(Searcher searcher, Query query, Filter filter) {
        return searcher.getFirst(MAPPER, query, filter, null, null);
    }

    public static ItemResult<Node> getFirst(Searcher searcher, Query query) {
        return TestSupport.getFirst(searcher, query, null);
    }

    public static ItemResult<Node> getFirst(Searcher searcher, int value, Filter filter) {
        return TestSupport.getFirst(searcher, (Query)new TermQuery(TestSupport.termId(value)), filter);
    }

    public static ItemResult<Node> getFirst(Searcher searcher, int value) {
        return TestSupport.getFirst(searcher, value, null);
    }

    public static PageResult<Node> getPage(Searcher searcher, int from, int to, int first, int max, Filter filter) {
        return searcher.getPage(MAPPER, (Query)NumericRangeQuery.newIntRange((String)ID.getName(), (Integer)from, (Integer)to, (boolean)true, (boolean)true), first, max, filter, null, null);
    }

    public static PageResult<Node> getPage(Searcher searcher, int from, int to, int first, int max) {
        return TestSupport.getPage(searcher, from, to, first, max, null);
    }

    public static int getCount(Searcher searcher, Filter filter) {
        return searcher.getCount((Query)new MatchAllDocsQuery(), filter, false).getTotalHits();
    }

    public static int getCount(Searcher searcher) {
        return TestSupport.getCount(searcher, null);
    }

    public static void found(Searcher searcher, int value, Filter filter) {
        ItemResult<Node> item = TestSupport.getFirst(searcher, value, filter);
        Assert.assertNotNull(item);
        Assert.assertTrue((boolean)item.isFound());
        Node node = (Node)item.getItem();
        Assert.assertNotNull((Object)node);
        node.test(value);
    }

    public static void found(Searcher searcher, int value) {
        TestSupport.found(searcher, value, null);
    }

    public static void notFound(Searcher searcher, int value, Filter filter) {
        ItemResult<Node> item = TestSupport.getFirst(searcher, value, filter);
        Assert.assertNotNull(item);
        Assert.assertFalse((boolean)item.isFound());
    }

    public static void notFound(Searcher searcher, int value) {
        TestSupport.notFound(searcher, value, null);
    }

    public static void write(Directory directory, String base, int from, int to) throws IOException {
        IndexWriter w = new IndexWriter(directory, Conquiris.writerConfig());
        int min = Math.min(from, to);
        int max = Math.max(from, to);
        for (int i = min; i <= max; ++i) {
            w.addDocument(TestSupport.document(i, base));
        }
        w.close();
    }

    public static void write(Directory directory, int from, int to) throws IOException {
        TestSupport.write(directory, null, from, to);
    }

    public static Directory createRAMDirectory(String base, int from, int to) throws IOException {
        RAMDirectory directory = new RAMDirectory();
        TestSupport.write((Directory)directory, base, from, to);
        return directory;
    }

    public static Directory createRAMDirectory(int from, int to) throws IOException {
        return TestSupport.createRAMDirectory(null, from, to);
    }

    public static ReaderSupplier createRAMSupplier(int from, int to) throws IOException {
        return ReaderSuppliers.directory((Directory)TestSupport.createRAMDirectory(from, to));
    }

    private static void checkPage(PageResult<?> page, int first, int size) {
        Assert.assertNotNull(page);
        Assert.assertEquals((int)page.size(), (int)size);
        Assert.assertEquals((boolean)page.isEmpty(), (size == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)page.getFirstRequestedResult(), (int)first);
        if (size > 0) {
            Assert.assertEquals((int)page.getFirstResult(), (int)first);
            Assert.assertNotNull((Object)page.getItems());
            Assert.assertEquals((int)page.getItems().size(), (int)size);
        }
    }

    public static void performEmptyQueries(Searcher searcher) {
        for (int i = 0; i < 500; ++i) {
            TestSupport.notFound(searcher, i);
        }
        TestSupport.checkPage(TestSupport.getPage(searcher, 3, 67, 0, 10), 0, 0);
        TestSupport.checkPage(TestSupport.getPage(searcher, 3, 67, 100, 10), 100, 0);
    }

    public static void performQueries(Searcher searcher, int from, int to) {
        int n = to - from + 1;
        Assert.assertTrue((n > 1 ? 1 : 0) != 0);
        TestSupport.found(searcher, from);
        TestSupport.found(searcher, to);
        TestSupport.notFound(searcher, from - 1);
        TestSupport.notFound(searcher, to + 1);
        TestSupport.found(searcher, (from + to) / 2);
        int p = Math.min(5, n);
        TestSupport.checkPage(TestSupport.getPage(searcher, from, from + p, 0, p), 0, p);
        TestSupport.checkPage(TestSupport.getPage(searcher, to - p + 1, to, 0, p), 0, p);
        TestSupport.checkPage(TestSupport.getPage(searcher, to - p + 1, to + 2 * p, 0, 3 * p), 0, p);
        int f = Math.max(0, from - 5);
        if (f > 0) {
            TestSupport.checkPage(TestSupport.getPage(searcher, f, f + 10, 0, 20), 0, f + 10 - from + 1);
        }
    }

    public static void performQueriesInService(SearcherService service, final int from, final int to) {
        TestSupport.performQueries((Searcher)service, from, to);
        service.search((Function)new Function<Searcher, Object>(){

            public Object apply(Searcher input) {
                TestSupport.performQueries(input, from, to);
                return null;
            }
        });
    }

    public static class Node {
        private int id;
        private String analyzed;

        public void test(int value) {
            Assert.assertEquals((int)this.id, (int)value);
            Assert.assertEquals((String)this.analyzed, (String)TestSupport.value(value));
        }
    }
}

