/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import com.google.common.primitives.Longs;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.conquiris.api.search.ManagedReaderSupplier;
import net.conquiris.api.search.ReaderSupplier;
import net.conquiris.api.search.Searcher;
import net.conquiris.api.search.SearcherService;
import net.conquiris.search.ReaderSuppliers;
import net.conquiris.search.Searchers;
import net.conquiris.support.TestSupport;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SearchersTest {
    private static final int FROM = 1000;
    private static final int TO = 10000;
    private static final int ALPHA = 100000;
    private Directory directory;
    private ReaderSupplier supplier;
    private ReaderSupplier unmanaged;
    private ManagedReaderSupplier managed;
    private SearcherService unmanagedSearcher;
    private SearcherService managedSearcher;
    private final SecureRandom random = new SecureRandom(Longs.toByteArray((long)System.currentTimeMillis()));

    private void create() {
        this.directory = new RAMDirectory();
        this.supplier = ReaderSuppliers.directory((Directory)this.directory);
        this.unmanaged = ReaderSuppliers.directory((Directory)this.directory);
        this.managed = ReaderSuppliers.managed((ReaderSupplier)this.unmanaged, (long)50L);
        this.unmanagedSearcher = Searchers.service((ReaderSupplier)this.supplier);
        this.managedSearcher = Searchers.service((ReaderSupplier)this.managed);
    }

    private void write(int scale) {
        try {
            int delta = scale * 100000;
            TestSupport.write(this.directory, delta + 1000, delta + 10000);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createFull() {
        this.create();
        this.write(0);
    }

    @Test
    public void empty() {
        this.create();
        TestSupport.performEmptyQueries((Searcher)this.unmanagedSearcher);
        TestSupport.performEmptyQueries((Searcher)this.managedSearcher);
        Assert.assertEquals((long)this.managed.getRequested(), (long)this.unmanaged.getRequested());
        Assert.assertEquals((long)this.managed.getReopened(), (long)0L);
        Assert.assertEquals((long)this.managed.getReused(), (long)0L);
        this.show("Empty");
    }

    private void show(String test) {
        System.out.printf("===== BEGIN %s\n", test);
        System.out.printf("Supplier: %d requested\n", this.supplier.getRequested());
        System.out.printf("Unmanaged: %d requested\n", this.unmanaged.getRequested());
        System.out.printf("Managed: %d requested, %d reopened, %d reused\n", this.managed.getRequested(), this.managed.getReopened(), this.managed.getReused());
        System.out.printf("===== END %s\n\n", test);
        Assert.assertTrue((this.unmanaged.getRequested() <= this.supplier.getRequested() ? 1 : 0) != 0);
        Assert.assertEquals((long)this.managed.getRequested(), (long)this.supplier.getRequested());
    }

    @Test(dependsOnMethods={"empty"})
    public void added() {
        this.write(0);
        TestSupport.performQueriesInService(this.unmanagedSearcher, 1000, 10000);
        TestSupport.performQueriesInService(this.managedSearcher, 1000, 10000);
        this.show("Added over empty");
    }

    @Test(dependsOnMethods={"added"})
    public void single() throws Exception {
        int i;
        this.createFull();
        for (i = 0; i < 5; ++i) {
            Thread.sleep(20L);
            TestSupport.performQueriesInService(this.unmanagedSearcher, 1000, 10000);
            TestSupport.performQueriesInService(this.managedSearcher, 1000, 10000);
        }
        this.write(1);
        for (i = 0; i < 5; ++i) {
            Thread.sleep(30L);
            TestSupport.performQueriesInService(this.unmanagedSearcher, 1000, 10000);
            TestSupport.performQueriesInService(this.managedSearcher, 1000, 10000);
            this.write(2 + i);
        }
        this.show("Simple");
    }

    private void sleep(long base, int range) {
        try {
            Thread.sleep(base + (long)this.random.nextInt(range));
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private ExecutorService executor(int threads, int tasks) throws Exception {
        this.createFull();
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SearchersTest.this.sleep(19L, 15);
                TestSupport.performQueriesInService(SearchersTest.this.unmanagedSearcher, 1000, 10000);
                TestSupport.performQueriesInService(SearchersTest.this.managedSearcher, 1000, 10000);
            }
        };
        for (int i = 0; i < tasks; ++i) {
            executor.submit(r);
        }
        return executor;
    }

    private void join(String test, ExecutorService executor) throws Exception {
        executor.shutdown();
        while (!executor.awaitTermination(30L, TimeUnit.SECONDS)) {
            System.out.printf("Waiting %s...\n", test);
        }
        this.show(test);
    }

    @Test(dependsOnMethods={"single"})
    public void concurrent() throws Exception {
        this.createFull();
        this.join("Concurrent", this.executor(5, 200));
    }

    @Test(dependsOnMethods={"concurrent"})
    public void complexConcurrent() throws Exception {
        this.createFull();
        ExecutorService s = this.executor(5, 2000);
        for (int i = 0; i < 10; ++i) {
            this.sleep(2L, 10);
            this.write(3 + i);
        }
        this.join("Complex Concurrent", s);
    }
}

