/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import net.conquiris.api.search.AbstractHitMapper;
import net.conquiris.api.search.HitMapper;
import net.conquiris.api.search.ReaderSupplier;
import net.conquiris.api.search.Searcher;
import net.conquiris.api.search.SearcherService;
import net.conquiris.lucene.document.FieldSelectors;
import net.conquiris.lucene.search.Hit;
import net.conquiris.schema.SchemaItem;
import net.conquiris.search.ReaderSuppliers;
import net.conquiris.search.Searchers;
import net.conquiris.support.TestSupport;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FieldSelectorTest {
    private static final HitMapper<Integer> MAPPER = new AbstractHitMapper<Integer>(FieldSelectors.loadItems((SchemaItem[])new SchemaItem[]{TestSupport.ID})){

        public Integer apply(Hit hit) {
            return (Integer)hit.item(TestSupport.ID).get();
        }
    };

    private boolean found(Searcher s, int value) {
        return s.getFirst(MAPPER, (Query)new TermQuery(TestSupport.termId(value)), null, null, null).isFound();
    }

    private void checkFound(Searcher s, int found, int notFound) {
        Assert.assertTrue((boolean)this.found(s, found));
        Assert.assertFalse((boolean)this.found(s, notFound));
    }

    @Test
    public void test() throws Exception {
        Directory d = TestSupport.createRAMDirectory(1, 10);
        SearcherService s = Searchers.service((ReaderSupplier)ReaderSuppliers.managed((Directory)d));
        this.checkFound((Searcher)s, 4, 15);
        TestSupport.write(d, 11, 15);
        this.checkFound((Searcher)s, 4, 25);
        this.checkFound((Searcher)s, 14, 35);
    }
}

