/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import com.google.common.base.Preconditions;
import java.io.IOException;
import net.conquiris.api.search.Reader;
import net.conquiris.search.AbstractReaderSupplier;
import net.conquiris.search.ReaderSuppliers;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;

final class IndexWriterReaderSupplier
extends AbstractReaderSupplier {
    private final IndexWriter writer;

    IndexWriterReaderSupplier(IndexWriter writer) {
        this.writer = (IndexWriter)Preconditions.checkNotNull((Object)writer, (Object)"The index writer must be provided");
    }

    @Override
    Reader doGet() throws IOException {
        try {
            IndexReader reader = IndexReader.open((IndexWriter)this.writer, (boolean)true);
            return Reader.of(reader, true);
        }
        catch (IndexNotFoundException e) {
            return ReaderSuppliers.empty().get();
        }
    }
}

